/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.persistence;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.context.JpaRootContextNode;
import org.eclipse.jpt.core.context.persistence.Persistence;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.core.internal.context.persistence.AbstractPersistenceJpaContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.PersistenceResource;
import org.eclipse.jpt.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericPersistenceXml
extends AbstractPersistenceJpaContextNode
implements PersistenceXml {
    protected PersistenceResource persistenceResource;
    protected Persistence persistence;
    private boolean okToContinueValidation = true;

    public GenericPersistenceXml(JpaRootContextNode parent, PersistenceResource persistenceResource) {
        super(parent);
        this.initialize(persistenceResource);
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public JpaRootContextNode getParent() {
        return (JpaRootContextNode)super.getParent();
    }

    @Override
    public IResource getResource() {
        return this.persistenceResource.getFile();
    }

    @Override
    public Persistence getPersistence() {
        return this.persistence;
    }

    @Override
    public Persistence addPersistence() {
        if (this.persistence != null) {
            throw new IllegalStateException();
        }
        XmlPersistence xmlPersistence = PersistenceFactory.eINSTANCE.createXmlPersistence();
        this.persistence = this.buildPersistence(xmlPersistence);
        this.persistenceResource.getContents().add((Object)xmlPersistence);
        this.firePropertyChanged("persistence", null, this.persistence);
        return this.persistence;
    }

    @Override
    public void removePersistence() {
        if (this.persistence == null) {
            throw new IllegalStateException();
        }
        Persistence oldPersistence = this.persistence;
        this.persistence = null;
        XmlPersistence xmlPersistence = this.persistenceResource.getPersistence();
        this.persistenceResource.getContents().remove((Object)xmlPersistence);
        this.firePropertyChanged("persistence", oldPersistence, null);
    }

    protected void setPersistence_(Persistence newPersistence) {
        Persistence oldPersistence = this.persistence;
        this.persistence = newPersistence;
        this.firePropertyChanged("persistence", oldPersistence, newPersistence);
    }

    protected void initialize(PersistenceResource persistenceResource) {
        this.persistenceResource = persistenceResource;
        if (persistenceResource.getPersistence() != null) {
            this.persistence = this.buildPersistence(persistenceResource.getPersistence());
        }
    }

    @Override
    public void update(PersistenceResource persistenceResource) {
        if (!((Object)((Object)persistenceResource)).equals((Object)this.persistenceResource)) {
            this.persistenceResource = persistenceResource;
            this.persistenceResource.getResourceModel().removeRootStructureNode(this);
        }
        if (persistenceResource.getPersistence() != null) {
            if (this.persistence != null) {
                this.persistence.update(persistenceResource.getPersistence());
            } else {
                this.setPersistence_(this.buildPersistence(persistenceResource.getPersistence()));
            }
            persistenceResource.getResourceModel().addRootStructureNode(this.getPersistence());
        } else {
            this.setPersistence_(null);
        }
    }

    protected Persistence buildPersistence(XmlPersistence xmlPersistence) {
        return this.getJpaFactory().buildPersistence(this, xmlPersistence);
    }

    @Override
    public PersistenceUnit getPersistenceUnit() {
        throw new UnsupportedOperationException("No PersistenceUnit in this context");
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        if (this.persistence.containsOffset(textOffset)) {
            return this.persistence.getStructureNode(textOffset);
        }
        return this;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return TextRange.Empty.instance();
    }

    @Override
    public TextRange getValidationTextRange() {
        return TextRange.Empty.instance();
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        this.addInvalidPersistenceXmlContentMessage(messages);
        if (this.okToContinueValidation) {
            this.getPersistence().addToMessages(messages);
        }
    }

    protected void addInvalidPersistenceXmlContentMessage(List<IMessage> messages) {
        if (this.persistence == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_XML_INVALID_CONTENT", this));
            this.okToContinueValidation = false;
        }
    }
}

