/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.persistence;

import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.Property;
import org.eclipse.jpt.core.internal.context.persistence.AbstractPersistenceJpaContextNode;
import org.eclipse.jpt.core.resource.persistence.XmlProperty;
import org.eclipse.jpt.core.utility.TextRange;

public class GenericProperty
extends AbstractPersistenceJpaContextNode
implements Property {
    protected String name;
    protected String value;
    protected XmlProperty property;

    public GenericProperty(PersistenceUnit parent, XmlProperty property) {
        super(parent);
        this.initialize(property);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.property.setName(newName);
        this.firePropertyChanged("name", oldName, newName);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String newValue) {
        String oldValue = this.value;
        this.value = newValue;
        this.property.setValue(newValue);
        this.firePropertyChanged("value", oldValue, newValue);
    }

    protected void initialize(XmlProperty property) {
        this.property = property;
        this.name = property.getName();
        this.value = property.getValue();
    }

    public void update(XmlProperty property) {
        this.property = property;
        this.setName(property.getName());
        this.setValue(property.getValue());
    }

    public TextRange getValidationTextRange() {
        return this.property.getValidationTextRange();
    }

    public void toString(StringBuilder sb) {
        sb.append(" (name: ");
        sb.append(this.name);
        sb.append(", value: ");
        sb.append(this.value);
        sb.append(')');
    }
}

