/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jpt.core.JpaPlatform;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.ReadOnlyIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaPlatformRegistry {
    private final HashMap<String, IConfigurationElement> jpaPlatformConfigurationElements = this.buildJpaPlatformConfigurationElements();
    private static final JpaPlatformRegistry INSTANCE = new JpaPlatformRegistry();
    private static final String EXTENSION_ID = "jpaPlatform";
    private static final String EL_PLATFORM = "jpaPlatform";
    private static final String AT_ID = "id";
    private static final String AT_LABEL = "label";
    private static final String AT_CLASS = "class";

    public static JpaPlatformRegistry instance() {
        return INSTANCE;
    }

    private JpaPlatformRegistry() {
    }

    private HashMap<String, IConfigurationElement> buildJpaPlatformConfigurationElements() {
        HashMap<String, IConfigurationElement> configElements = new HashMap<String, IConfigurationElement>();
        Iterator<IConfigurationElement> stream = this.configElements();
        while (stream.hasNext()) {
            this.addConfigElementTo(stream.next(), configElements);
        }
        return configElements;
    }

    private Iterator<IConfigurationElement> configElements() {
        return new CompositeIterator((Iterator)new TransformationIterator<IExtension, Iterator<IConfigurationElement>>(this.extensions()){

            protected Iterator<IConfigurationElement> transform(IExtension extension) {
                return CollectionTools.iterator((Object[])extension.getConfigurationElements());
            }
        });
    }

    private Iterator<IExtension> extensions() {
        return CollectionTools.iterator((Object[])this.extensionPoint().getExtensions());
    }

    private IExtensionPoint extensionPoint() {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jpt.core", "jpaPlatform");
    }

    private void addConfigElementTo(IConfigurationElement configElement, HashMap<String, IConfigurationElement> configElements) {
        if (!configElement.getName().equals("jpaPlatform")) {
            return;
        }
        if (!this.configElementIsValid(configElement)) {
            return;
        }
        String id = configElement.getAttribute(AT_ID);
        IConfigurationElement prev = configElements.get(id);
        if (prev == null) {
            configElements.put(id, configElement);
        } else {
            this.logDuplicatePlatform(prev, configElement);
        }
    }

    private boolean configElementIsValid(IConfigurationElement configElement) {
        boolean valid = true;
        if (configElement.getAttribute(AT_ID) == null) {
            this.logMissingAttribute(configElement, AT_ID);
            valid = false;
        }
        if (configElement.getAttribute(AT_LABEL) == null) {
            this.logMissingAttribute(configElement, AT_LABEL);
            valid = false;
        }
        if (configElement.getAttribute(AT_CLASS) == null) {
            this.logMissingAttribute(configElement, AT_CLASS);
            valid = false;
        }
        return valid;
    }

    public Iterator<String> jpaPlatformIds() {
        return new ReadOnlyIterator((Collection)this.jpaPlatformConfigurationElements.keySet());
    }

    public String getJpaPlatformLabel(String id) {
        return this.jpaPlatformConfigurationElements.get(id).getAttribute(AT_LABEL);
    }

    public JpaPlatform getJpaPlatform(String id) {
        JpaPlatform platform;
        IConfigurationElement configElement = this.jpaPlatformConfigurationElements.get(id);
        if (configElement == null) {
            throw new IllegalArgumentException(id);
        }
        try {
            platform = (JpaPlatform)configElement.createExecutableExtension(AT_CLASS);
        }
        catch (CoreException ex) {
            this.logFailedInstantiation(configElement, ex);
            throw new IllegalArgumentException(id);
        }
        platform.setId(id);
        return platform;
    }

    private void logMissingAttribute(IConfigurationElement configElement, String attributeName) {
        String message = "An extension element \"" + configElement.getName() + "\" in plugin \"" + configElement.getContributor().getName() + "\" is missing a required attribute \"" + attributeName + "\".";
        JptCorePlugin.log(message);
    }

    private void logDuplicatePlatform(IConfigurationElement prevConfigElement, IConfigurationElement newConfigElement) {
        String message = "The plugins \"" + prevConfigElement.getContributor().getName() + "\" and \"" + newConfigElement.getContributor().getName() + "\" have registered a duplicate attribute \"id\" " + "for the extension element \"jpaPlatform\".";
        JptCorePlugin.log(message);
    }

    private void logFailedInstantiation(IConfigurationElement configElement, CoreException ex) {
        String message = "Could not instantiate the class \"" + configElement.getAttribute(AT_CLASS) + "\" for the extension element \"" + configElement.getName() + "\" in the plugin \"" + configElement.getContributor().getName() + "\".";
        JptCorePlugin.log(message);
        JptCorePlugin.log(ex);
    }
}

