/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractJavaResourceNode;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceAnnotation<E extends Member>
extends AbstractJavaResourceNode
implements Annotation {
    private final E member;
    private final DeclarationAnnotationAdapter daa;
    private final AnnotationAdapter annotationAdapter;

    protected AbstractResourceAnnotation(JavaResourceNode parent, E member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent);
        this.member = member;
        this.daa = daa;
        this.annotationAdapter = annotationAdapter;
    }

    public E getMember() {
        return this.member;
    }

    protected AbstractResourceAnnotation(JavaResourceNode parent, E member, DeclarationAnnotationAdapter daa) {
        this(parent, member, daa, new MemberAnnotationAdapter((Member)member, daa));
    }

    public AnnotationAdapter getAnnotationAdapter() {
        return this.annotationAdapter;
    }

    @Override
    public org.eclipse.jdt.core.dom.Annotation getJdtAnnotation(CompilationUnit astRoot) {
        return this.getAnnotationAdapter().getAnnotation(astRoot);
    }

    public DeclarationAnnotationAdapter getDeclarationAnnotationAdapter() {
        return this.daa;
    }

    @Override
    public void removeAnnotation() {
        this.getAnnotationAdapter().removeAnnotation();
    }

    @Override
    public void newAnnotation() {
        this.getAnnotationAdapter().newMarkerAnnotation();
    }

    @Override
    public TextRange getTextRange(CompilationUnit astRoot) {
        return this.getMember().getAnnotationTextRange(this.daa, astRoot);
    }

    protected TextRange elementTextRange(DeclarationAnnotationElementAdapter<?> elementAdapter, CompilationUnit astRoot) {
        return this.elementTextRange(this.member.getAnnotationElementTextRange(elementAdapter, astRoot), astRoot);
    }

    protected TextRange elementTextRange(TextRange elementTextRange, CompilationUnit astRoot) {
        return elementTextRange != null ? elementTextRange : this.getTextRange(astRoot);
    }

    protected boolean elementTouches(DeclarationAnnotationElementAdapter<?> elementAdapter, int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.member.getAnnotationElementTextRange(elementAdapter, astRoot), pos);
    }

    protected boolean elementTouches(TextRange elementTextRange, int pos) {
        return elementTextRange != null && elementTextRange.touches(pos);
    }
}

