/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.resource.java.NullBasic;
import org.eclipse.jpt.core.internal.utility.jdt.BooleanExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.BasicAnnotation;
import org.eclipse.jpt.core.resource.java.FetchType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicImpl
extends AbstractResourceAnnotation<Attribute>
implements BasicAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.Basic");
    private final AnnotationElementAdapter<Boolean> optionalAdapter;
    private final AnnotationElementAdapter<String> fetchAdapter;
    private static final DeclarationAnnotationElementAdapter<Boolean> OPTIONAL_ADAPTER = BasicImpl.buildOptionalAdapter();
    private static final DeclarationAnnotationElementAdapter<String> FETCH_ADAPTER = BasicImpl.buildFetchAdapter();
    private Boolean optional;
    private FetchType fetch;

    protected BasicImpl(JavaResourcePersistentAttribute parent, Attribute attribute) {
        super(parent, attribute, DECLARATION_ANNOTATION_ADAPTER);
        this.optionalAdapter = new ShortCircuitAnnotationElementAdapter<Boolean>(attribute, OPTIONAL_ADAPTER);
        this.fetchAdapter = new ShortCircuitAnnotationElementAdapter<String>(attribute, FETCH_ADAPTER);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.optional = this.optional(astRoot);
        this.fetch = this.fetch(astRoot);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.Basic";
    }

    @Override
    public Boolean getOptional() {
        return this.optional;
    }

    @Override
    public void setOptional(Boolean newOptional) {
        Boolean oldOptional = this.optional;
        this.optional = newOptional;
        this.optionalAdapter.setValue(newOptional);
        this.firePropertyChanged("optionalProperty", oldOptional, newOptional);
    }

    @Override
    public FetchType getFetch() {
        return this.fetch;
    }

    @Override
    public void setFetch(FetchType newFetch) {
        FetchType oldFetch = this.fetch;
        this.fetch = newFetch;
        this.fetchAdapter.setValue(FetchType.toJavaAnnotationValue(newFetch));
        this.firePropertyChanged("fetchProperty", (Object)oldFetch, (Object)newFetch);
    }

    @Override
    public TextRange getFetchTextRange(CompilationUnit astRoot) {
        return this.elementTextRange(FETCH_ADAPTER, astRoot);
    }

    @Override
    public TextRange getOptionalTextRange(CompilationUnit astRoot) {
        return this.elementTextRange(OPTIONAL_ADAPTER, astRoot);
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        this.setOptional(this.optional(astRoot));
        this.setFetch(this.fetch(astRoot));
    }

    protected FetchType fetch(CompilationUnit astRoot) {
        return FetchType.fromJavaAnnotationValue(this.fetchAdapter.getValue(astRoot));
    }

    protected Boolean optional(CompilationUnit astRoot) {
        return this.optionalAdapter.getValue(astRoot);
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildOptionalAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter<Boolean>(DECLARATION_ANNOTATION_ADAPTER, "optional", false, BooleanExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String> buildFetchAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "fetch", false);
    }

    public static class BasicAnnotationDefinition
    implements AnnotationDefinition {
        private static final BasicAnnotationDefinition INSTANCE = new BasicAnnotationDefinition();

        public static BasicAnnotationDefinition instance() {
            return INSTANCE;
        }

        private BasicAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new BasicImpl((JavaResourcePersistentAttribute)parent, (Attribute)member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new NullBasic(parent);
        }

        public String getAnnotationName() {
            return "javax.persistence.Basic";
        }
    }
}

