/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.core.resource.java.ContainerAnnotation;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.utility.internal.CollectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerAnnotationTools {
    public static NestableAnnotation addNestedAnnotation(int index, ContainerAnnotation<? extends NestableAnnotation> containerAnnotation) {
        int size = containerAnnotation.nestedAnnotationsSize();
        NestableAnnotation nestedAnnotation = containerAnnotation.addInternal(size);
        nestedAnnotation.newAnnotation();
        containerAnnotation.moveInternal(index, size);
        ContainerAnnotationTools.synchAnnotationsAfterMove(index, size, containerAnnotation);
        return nestedAnnotation;
    }

    public static void synchAnnotationsAfterAdd(int index, ContainerAnnotation<? extends NestableAnnotation> containerAnnotation) {
        List nestableAnnotations = CollectionTools.list((Iterator)containerAnnotation.nestedAnnotations());
        int i = nestableAnnotations.size();
        while (i-- > index) {
            ContainerAnnotationTools.synch((NestableAnnotation)nestableAnnotations.get(i), i);
        }
    }

    public static void synchAnnotationsAfterRemove(int index, ContainerAnnotation<? extends NestableAnnotation> pluralAnnotation) {
        List nestableAnnotations = CollectionTools.list((Iterator)pluralAnnotation.nestedAnnotations());
        int i = index;
        while (i < nestableAnnotations.size()) {
            ContainerAnnotationTools.synch((NestableAnnotation)nestableAnnotations.get(i), i);
            ++i;
        }
    }

    private static void synch(NestableAnnotation nestableAnnotation, int index) {
        nestableAnnotation.moveAnnotation(index);
    }

    public static void synchAnnotationsAfterMove(int targetIndex, int sourceIndex, ContainerAnnotation<? extends NestableAnnotation> containerAnnotation) {
        NestableAnnotation nestableAnnotation = containerAnnotation.nestedAnnotationAt(targetIndex);
        ContainerAnnotationTools.synch(nestableAnnotation, containerAnnotation.nestedAnnotationsSize());
        List nestableAnnotations = CollectionTools.list((Iterator)containerAnnotation.nestedAnnotations());
        if (sourceIndex < targetIndex) {
            int i = sourceIndex;
            while (i < targetIndex) {
                ContainerAnnotationTools.synch((NestableAnnotation)nestableAnnotations.get(i), i);
                ++i;
            }
        } else {
            int i = sourceIndex;
            while (i > targetIndex) {
                ContainerAnnotationTools.synch((NestableAnnotation)nestableAnnotations.get(i), i);
                --i;
            }
        }
        ContainerAnnotationTools.synch(nestableAnnotation, targetIndex);
    }

    public static void initializeNestedAnnotations(CompilationUnit astRoot, ContainerAnnotation<?> containerAnnotation) {
        ContainerAnnotationTools.addAnnotationsFromSource(astRoot, containerAnnotation);
    }

    private static void addAnnotationsFromSource(CompilationUnit astRoot, ContainerAnnotation<? extends NestableAnnotation> containerAnnotation) {
        containerAnnotation.getJdtAnnotation(astRoot).accept(ContainerAnnotationTools.initialJavaMemberAnnotationAstVisitor(astRoot, containerAnnotation));
    }

    private static ASTVisitor initialJavaMemberAnnotationAstVisitor(final CompilationUnit astRoot, final ContainerAnnotation<? extends NestableAnnotation> containerAnnotation) {
        return new ASTVisitor(){

            public boolean visit(MemberValuePair node) {
                return node.getName().getFullyQualifiedName().equals(containerAnnotation.getElementName());
            }

            public boolean visit(SingleMemberAnnotation node) {
                return this.visit((Annotation)node);
            }

            public boolean visit(NormalAnnotation node) {
                return this.visit((Annotation)node);
            }

            public boolean visit(MarkerAnnotation node) {
                return this.visit((Annotation)node);
            }

            private boolean visit(Annotation node) {
                if (containerAnnotation.getAnnotationName().equals(JDTTools.resolveAnnotation(node))) {
                    return true;
                }
                if (containerAnnotation.getNestableAnnotationName().equals(JDTTools.resolveAnnotation(node))) {
                    org.eclipse.jpt.core.resource.java.Annotation nestedAnnotation = (org.eclipse.jpt.core.resource.java.Annotation)containerAnnotation.addInternal(containerAnnotation.nestedAnnotationsSize());
                    nestedAnnotation.initialize(astRoot);
                }
                return false;
            }
        };
    }

    public static void updateNestedAnnotationsFromJava(CompilationUnit astRoot, ContainerAnnotation<?> containerAnnotation) {
        ContainerAnnotationTools.addOrUpdateAnnotationInSource(astRoot, containerAnnotation);
        ContainerAnnotationTools.removeAnnotationsNotInSource(astRoot, containerAnnotation);
    }

    private static void addOrUpdateAnnotationInSource(CompilationUnit astRoot, ContainerAnnotation<? extends NestableAnnotation> containerAnnotation) {
        containerAnnotation.getJdtAnnotation(astRoot).accept(ContainerAnnotationTools.javaMemberAnnotationAstVisitor(astRoot, containerAnnotation));
    }

    private static void removeAnnotationsNotInSource(CompilationUnit astRoot, ContainerAnnotation<NestableAnnotation> containerAnnotation) {
        for (NestableAnnotation annotation : CollectionTools.iterable((Iterator)containerAnnotation.nestedAnnotations())) {
            if (annotation.getJdtAnnotation(astRoot) != null) continue;
            containerAnnotation.remove(annotation);
        }
    }

    private static ASTVisitor javaMemberAnnotationAstVisitor(final CompilationUnit astRoot, final ContainerAnnotation<? extends NestableAnnotation> containerAnnotation) {
        return new ASTVisitor(){

            public boolean visit(MemberValuePair node) {
                return node.getName().getFullyQualifiedName().equals(containerAnnotation.getElementName());
            }

            public boolean visit(SingleMemberAnnotation node) {
                return this.visit((Annotation)node);
            }

            public boolean visit(NormalAnnotation node) {
                return this.visit((Annotation)node);
            }

            public boolean visit(MarkerAnnotation node) {
                return this.visit((Annotation)node);
            }

            private boolean visit(Annotation node) {
                if (containerAnnotation.getAnnotationName().equals(JDTTools.resolveAnnotation(node))) {
                    return true;
                }
                if (containerAnnotation.getNestableAnnotationName().equals(JDTTools.resolveAnnotation(node))) {
                    Object nestedAnnotation = containerAnnotation.nestedAnnotationFor(node);
                    if (nestedAnnotation != null) {
                        nestedAnnotation.updateFromJava(astRoot);
                    } else {
                        nestedAnnotation = containerAnnotation.add(containerAnnotation.nestedAnnotationsSize());
                        nestedAnnotation.initialize(astRoot);
                    }
                }
                return false;
            }
        };
    }
}

