/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.GeneratedValueAnnotation;
import org.eclipse.jpt.core.resource.java.GenerationType;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratedValueImpl
extends AbstractResourceAnnotation<Member>
implements GeneratedValueAnnotation {
    private final AnnotationElementAdapter<String> strategyAdapter;
    private final AnnotationElementAdapter<String> generatorAdapter;
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.GeneratedValue");
    private static final DeclarationAnnotationElementAdapter<String> STRATEGY_ADAPTER = GeneratedValueImpl.buildStrategyAdapter();
    private static final DeclarationAnnotationElementAdapter<String> GENERATOR_ADAPTER = GeneratedValueImpl.buildGeneratorAdapter();
    private GenerationType strategy;
    private String generator;

    protected GeneratedValueImpl(JavaResourceNode parent, Member member) {
        super(parent, member, DECLARATION_ANNOTATION_ADAPTER);
        this.strategyAdapter = new ShortCircuitAnnotationElementAdapter<String>(member, STRATEGY_ADAPTER);
        this.generatorAdapter = new ShortCircuitAnnotationElementAdapter<String>(member, GENERATOR_ADAPTER);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.strategy = this.strategy(astRoot);
        this.generator = this.generator(astRoot);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.GeneratedValue";
    }

    @Override
    public GenerationType getStrategy() {
        return this.strategy;
    }

    @Override
    public void setStrategy(GenerationType newStrategy) {
        GenerationType oldStrategy = this.strategy;
        this.strategy = newStrategy;
        this.strategyAdapter.setValue(GenerationType.toJavaAnnotationValue(newStrategy));
        this.firePropertyChanged("strategyProperty", (Object)oldStrategy, (Object)newStrategy);
    }

    @Override
    public String getGenerator() {
        return this.generator;
    }

    @Override
    public void setGenerator(String newGenerator) {
        String oldGenerator = this.generator;
        this.generator = newGenerator;
        this.generatorAdapter.setValue(newGenerator);
        this.firePropertyChanged("generatorProperty", oldGenerator, newGenerator);
    }

    @Override
    public TextRange getStrategyTextRange(CompilationUnit astRoot) {
        return this.elementTextRange(STRATEGY_ADAPTER, astRoot);
    }

    @Override
    public TextRange getGeneratorTextRange(CompilationUnit astRoot) {
        return this.elementTextRange(GENERATOR_ADAPTER, astRoot);
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        this.setStrategy(this.strategy(astRoot));
        this.setGenerator(this.generator(astRoot));
    }

    protected GenerationType strategy(CompilationUnit astRoot) {
        return GenerationType.fromJavaAnnotationValue(this.strategyAdapter.getValue(astRoot));
    }

    protected String generator(CompilationUnit astRoot) {
        return this.generatorAdapter.getValue(astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildStrategyAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "strategy", false);
    }

    private static DeclarationAnnotationElementAdapter<String> buildGeneratorAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(DECLARATION_ANNOTATION_ADAPTER, "generator", false);
    }

    public static class GeneratedValueAnnotationDefinition
    implements AnnotationDefinition {
        private static final GeneratedValueAnnotationDefinition INSTANCE = new GeneratedValueAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private GeneratedValueAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new GeneratedValueImpl(parent, member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return null;
        }

        public String getAnnotationName() {
            return "javax.persistence.GeneratedValue";
        }
    }
}

