/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NumberIntegerExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.resource.java.GeneratorAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeneratorImpl
extends AbstractResourceAnnotation<Member>
implements GeneratorAnnotation {
    private final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter = this.nameAdapter();
    private final DeclarationAnnotationElementAdapter<Integer> initialValueDeclarationAdapter;
    private final DeclarationAnnotationElementAdapter<Integer> allocationSizeDeclarationAdapter;
    private final AnnotationElementAdapter<String> nameAdapter = this.buildAdapter(this.nameDeclarationAdapter);
    private final AnnotationElementAdapter<Integer> initialValueAdapter;
    private final AnnotationElementAdapter<Integer> allocationSizeAdapter;
    private String name;
    private Integer initialValue;
    private Integer allocationSize;

    public GeneratorImpl(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa) {
        super(parent, member, daa);
        this.initialValueDeclarationAdapter = this.initialValueAdapter();
        this.initialValueAdapter = this.buildIntegerAdapter(this.initialValueDeclarationAdapter);
        this.allocationSizeDeclarationAdapter = this.allocationSizeAdapter();
        this.allocationSizeAdapter = this.buildIntegerAdapter(this.allocationSizeDeclarationAdapter);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.name = this.name(astRoot);
        this.initialValue = this.initialValue(astRoot);
        this.allocationSize = this.allocationSize(astRoot);
    }

    protected AnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new ShortCircuitAnnotationElementAdapter<String>((Member)this.getMember(), daea);
    }

    protected AnnotationElementAdapter<Integer> buildIntegerAdapter(DeclarationAnnotationElementAdapter<Integer> daea) {
        return new ShortCircuitAnnotationElementAdapter<Integer>((Member)this.getMember(), daea);
    }

    protected abstract DeclarationAnnotationAdapter annotationAdapter();

    protected abstract DeclarationAnnotationElementAdapter<String> nameAdapter();

    protected abstract DeclarationAnnotationElementAdapter<Integer> initialValueAdapter();

    protected abstract DeclarationAnnotationElementAdapter<Integer> allocationSizeAdapter();

    @Override
    public Integer getAllocationSize() {
        return this.allocationSize;
    }

    @Override
    public void setAllocationSize(Integer newAllocationSize) {
        Integer oldAllocationSize = this.allocationSize;
        this.allocationSize = newAllocationSize;
        this.allocationSizeAdapter.setValue(newAllocationSize);
        this.firePropertyChanged("allocationSizeProperty", oldAllocationSize, newAllocationSize);
    }

    @Override
    public Integer getInitialValue() {
        return this.initialValue;
    }

    @Override
    public void setInitialValue(Integer newInitialValue) {
        Integer oldInitialValue = this.initialValue;
        this.initialValue = newInitialValue;
        this.initialValueAdapter.setValue(newInitialValue);
        this.firePropertyChanged("initialValueProperty", oldInitialValue, newInitialValue);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.nameAdapter.setValue(newName);
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.elementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    @Override
    public TextRange getInitialValueTextRange(CompilationUnit astRoot) {
        return this.elementTextRange(this.initialValueDeclarationAdapter, astRoot);
    }

    @Override
    public TextRange getAllocationSizeTextRange(CompilationUnit astRoot) {
        return this.elementTextRange(this.allocationSizeDeclarationAdapter, astRoot);
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        this.setName(this.name(astRoot));
        this.setAllocationSize(this.allocationSize(astRoot));
        this.setInitialValue(this.initialValue(astRoot));
    }

    protected String name(CompilationUnit astRoot) {
        return this.nameAdapter.getValue(astRoot);
    }

    protected Integer allocationSize(CompilationUnit astRoot) {
        return this.allocationSizeAdapter.getValue(astRoot);
    }

    protected Integer initialValue(CompilationUnit astRoot) {
        return this.initialValueAdapter.getValue(astRoot);
    }

    protected static DeclarationAnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(annotationAdapter, elementName);
    }

    protected static DeclarationAnnotationElementAdapter<Integer> buildIntegerAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter<Integer>(annotationAdapter, elementName, NumberIntegerExpressionConverter.instance());
    }
}

