/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.resource.java.NullInheritance;
import org.eclipse.jpt.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.InheritanceAnnotation;
import org.eclipse.jpt.core.resource.java.InheritanceType;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.core.utility.jdt.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InheritanceImpl
extends AbstractResourceAnnotation<Type>
implements InheritanceAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.Inheritance");
    private static final DeclarationAnnotationElementAdapter<String> STRATEGY_ADAPTER = InheritanceImpl.buildStrategyAdapter();
    private final AnnotationElementAdapter<String> strategyAdapter;
    private InheritanceType strategy;

    protected InheritanceImpl(JavaResourceNode parent, Type type) {
        super(parent, type, DECLARATION_ANNOTATION_ADAPTER);
        this.strategyAdapter = new ShortCircuitAnnotationElementAdapter<String>(type, STRATEGY_ADAPTER);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.strategy = this.strategy(astRoot);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.Inheritance";
    }

    @Override
    public InheritanceType getStrategy() {
        return this.strategy;
    }

    @Override
    public void setStrategy(InheritanceType newStrategy) {
        InheritanceType oldStrategy = this.strategy;
        this.strategy = newStrategy;
        this.strategyAdapter.setValue(InheritanceType.toJavaAnnotationValue(newStrategy));
        this.firePropertyChanged("strategyProperty", (Object)oldStrategy, (Object)newStrategy);
    }

    @Override
    public TextRange getStrategyTextRange(CompilationUnit astRoot) {
        return this.elementTextRange(STRATEGY_ADAPTER, astRoot);
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        this.setStrategy(this.strategy(astRoot));
    }

    protected InheritanceType strategy(CompilationUnit astRoot) {
        return InheritanceType.fromJavaAnnotationValue(this.strategyAdapter.getValue(astRoot));
    }

    private static DeclarationAnnotationElementAdapter<String> buildStrategyAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "strategy");
    }

    public static class InheritanceAnnotationDefinition
    implements AnnotationDefinition {
        private static final InheritanceAnnotationDefinition INSTANCE = new InheritanceAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private InheritanceAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new InheritanceImpl(parent, (Type)member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new NullInheritance(parent);
        }

        public String getAnnotationName() {
            return "javax.persistence.Inheritance";
        }
    }
}

