/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jpt.core.internal.resource.java.AbstractJavaResourcePersistentMember;
import org.eclipse.jpt.core.internal.resource.java.JavaResourcePersistentAttributeImpl;
import org.eclipse.jpt.core.internal.utility.jdt.JDTAttribute;
import org.eclipse.jpt.core.internal.utility.jdt.JDTFieldAttribute;
import org.eclipse.jpt.core.internal.utility.jdt.JDTMethodAttribute;
import org.eclipse.jpt.core.internal.utility.jdt.JDTType;
import org.eclipse.jpt.core.internal.utility.jdt.JPTTools;
import org.eclipse.jpt.core.resource.java.AccessType;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.utility.CommandExecutorProvider;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaResourcePersistentTypeImpl
extends AbstractJavaResourcePersistentMember<Type>
implements JavaResourcePersistentType {
    private final Collection<JavaResourcePersistentType> nestedTypes = new ArrayList<JavaResourcePersistentType>();
    private final Collection<JavaResourcePersistentAttribute> attributes = new ArrayList<JavaResourcePersistentAttribute>();
    private AccessType accessType;
    private String superClassQualifiedName;
    private String qualifiedName;
    private String name;
    private boolean isAbstract;

    public JavaResourcePersistentTypeImpl(JavaResourceNode parent, Type type) {
        super(parent, type);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.qualifiedName = this.qualifiedName(astRoot);
        this.name = this.name(astRoot);
        this.initializeNestedTypes(astRoot);
        this.initializeAttributes(astRoot);
        this.accessType = this.calculateAccessType();
        this.superClassQualifiedName = this.superClassQualifiedName(astRoot);
        this.isAbstract = this.isAbstract(astRoot);
    }

    protected void initializeNestedTypes(CompilationUnit astRoot) {
        IType[] iTypeArray = ((Type)this.getMember()).jdtTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType declaredType = iTypeArray[n2];
            this.nestedTypes.add(this.buildJavaResourcePersistentType(declaredType, astRoot));
            ++n2;
        }
    }

    protected void initializeAttributes(CompilationUnit astRoot) {
        IField[] iFieldArray = ((Type)this.getMember()).jdtFields();
        int n = iFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            this.attributes.add(this.createJavaPersistentAttribute((IMember)field, astRoot));
            ++n2;
        }
        iFieldArray = ((Type)this.getMember()).jdtMethods();
        n = iFieldArray.length;
        n2 = 0;
        while (n2 < n) {
            IField method = iFieldArray[n2];
            this.attributes.add(this.createJavaPersistentAttribute((IMember)method, astRoot));
            ++n2;
        }
    }

    @Override
    protected Annotation buildMappingAnnotation(String mappingAnnotationName) {
        return this.getAnnotationProvider().buildTypeMappingAnnotation(this, (Type)this.getMember(), mappingAnnotationName);
    }

    @Override
    protected Annotation buildNullMappingAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildNullTypeMappingAnnotation(this, (Type)this.getMember(), annotationName);
    }

    @Override
    protected Annotation buildAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildTypeAnnotation(this, (Type)this.getMember(), annotationName);
    }

    @Override
    protected Annotation buildNullAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildNullTypeAnnotation(this, (Type)this.getMember(), annotationName);
    }

    @Override
    protected ListIterator<String> possibleMappingAnnotationNames() {
        return this.getAnnotationProvider().typeMappingAnnotationNames();
    }

    @Override
    protected boolean isPossibleAnnotation(String annotationName) {
        return CollectionTools.contains(this.getAnnotationProvider().typeAnnotationNames(), (Object)annotationName);
    }

    @Override
    protected boolean isPossibleMappingAnnotation(String annotationName) {
        return CollectionTools.contains(this.getAnnotationProvider().typeMappingAnnotationNames(), (Object)annotationName);
    }

    @Override
    protected boolean calculatePersistability(CompilationUnit astRoot) {
        return JPTTools.typeIsPersistable(((Type)this.getMember()).getBinding(astRoot));
    }

    @Override
    public ListIterator<NestableAnnotation> annotations(String nestableAnnotationName, String containerAnnotationName) {
        return super.annotations(nestableAnnotationName, containerAnnotationName);
    }

    @Override
    public Iterator<Annotation> mappingAnnotations() {
        return super.mappingAnnotations();
    }

    @Override
    public Iterator<Annotation> annotations() {
        return super.annotations();
    }

    @Override
    public JavaResourcePersistentType getJavaPersistentTypeResource(String fullyQualifiedTypeName) {
        if (this.getQualifiedName().equals(fullyQualifiedTypeName)) {
            return this;
        }
        for (JavaResourcePersistentType jptr : CollectionTools.iterable(this.nestedTypes())) {
            if (!jptr.getQualifiedName().equals(fullyQualifiedTypeName)) continue;
            return jptr;
        }
        return null;
    }

    @Override
    public Iterator<JavaResourcePersistentType> nestedTypes() {
        return new FilteringIterator<JavaResourcePersistentType, JavaResourcePersistentType>((Iterator)new CloneIterator(this.nestedTypes)){

            protected boolean accept(JavaResourcePersistentType o) {
                return o.isPersistable();
            }
        };
    }

    protected JavaResourcePersistentType nestedTypeFor(IType type) {
        for (JavaResourcePersistentType nestedType : this.nestedTypes) {
            if (!nestedType.isFor((IMember)type)) continue;
            return nestedType;
        }
        return null;
    }

    protected JavaResourcePersistentType addNestedType(IType nestedType, CompilationUnit astRoot) {
        JavaResourcePersistentType persistentType = this.buildJavaResourcePersistentType(nestedType, astRoot);
        this.addNestedType(persistentType);
        return persistentType;
    }

    protected void addNestedType(JavaResourcePersistentType nestedType) {
        this.addItemToCollection(nestedType, this.nestedTypes, "nestedTypesCollection");
    }

    protected void removeNestedType(JavaResourcePersistentType nestedType) {
        this.removeItemFromCollection(nestedType, this.nestedTypes, "nestedTypesCollection");
    }

    protected JavaResourcePersistentType buildJavaResourcePersistentType(IType nestedType, CompilationUnit astRoot) {
        return JavaResourcePersistentTypeImpl.buildJavaResourcePersistentType(this, nestedType, this.getModifySharedDocumentCommandExecutorProvider(), this.getAnnotationEditFormatter(), astRoot);
    }

    public static JavaResourcePersistentType buildJavaResourcePersistentType(JavaResourceNode parent, IType nestedType, CommandExecutorProvider modifySharedDocumentCommandExecutorProvider, AnnotationEditFormatter annotationEditFormatter, CompilationUnit astRoot) {
        JDTType type = new JDTType(nestedType, modifySharedDocumentCommandExecutorProvider, annotationEditFormatter);
        JavaResourcePersistentTypeImpl javaPersistentType = new JavaResourcePersistentTypeImpl(parent, type);
        javaPersistentType.initialize(astRoot);
        return javaPersistentType;
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> attributes() {
        return new FilteringIterator<JavaResourcePersistentAttribute, JavaResourcePersistentAttribute>((Iterator)new CloneIterator(this.attributes)){

            protected boolean accept(JavaResourcePersistentAttribute o) {
                return o.isPersistable();
            }
        };
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> fields() {
        return new FilteringIterator<JavaResourcePersistentAttribute, JavaResourcePersistentAttribute>(this.attributes()){

            protected boolean accept(JavaResourcePersistentAttribute o) {
                return o.isForField();
            }
        };
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> properties() {
        return new FilteringIterator<JavaResourcePersistentAttribute, JavaResourcePersistentAttribute>(this.attributes()){

            protected boolean accept(JavaResourcePersistentAttribute o) {
                return o.isForProperty();
            }
        };
    }

    protected JavaResourcePersistentAttribute addAttribute(IMember jdtMember, CompilationUnit astRoot) {
        JavaResourcePersistentAttribute persistentAttribute = this.createJavaPersistentAttribute(jdtMember, astRoot);
        this.addAttribute(persistentAttribute);
        return persistentAttribute;
    }

    protected void addAttribute(JavaResourcePersistentAttribute attribute) {
        this.addItemToCollection(attribute, this.attributes, "attributesCollection");
    }

    protected JavaResourcePersistentAttribute createJavaPersistentAttribute(IMember member, CompilationUnit astRoot) {
        JDTAttribute attribute = null;
        if (member instanceof IField) {
            attribute = new JDTFieldAttribute((IField)member, this.getModifySharedDocumentCommandExecutorProvider(), this.getAnnotationEditFormatter());
        } else if (member instanceof IMethod) {
            attribute = new JDTMethodAttribute((IMethod)member, this.getModifySharedDocumentCommandExecutorProvider(), this.getAnnotationEditFormatter());
        } else {
            throw new IllegalArgumentException();
        }
        JavaResourcePersistentAttributeImpl javaPersistentAttribute = new JavaResourcePersistentAttributeImpl(this, attribute);
        javaPersistentAttribute.initialize(astRoot);
        return javaPersistentAttribute;
    }

    protected void removeAttribute(JavaResourcePersistentAttribute attribute) {
        this.removeItemFromCollection(attribute, this.attributes, "attributesCollection");
    }

    protected JavaResourcePersistentAttribute attributeFor(IMember member) {
        for (JavaResourcePersistentAttribute persistentAttribute : this.attributes) {
            if (!persistentAttribute.isFor(member)) continue;
            return persistentAttribute;
        }
        return null;
    }

    @Override
    public AccessType getAccess() {
        return this.accessType;
    }

    protected void setAccess(AccessType newAccess) {
        AccessType oldAccess = this.accessType;
        this.accessType = newAccess;
        this.firePropertyChanged("accessProperty", (Object)oldAccess, (Object)newAccess);
    }

    @Override
    public String getSuperClassQualifiedName() {
        return this.superClassQualifiedName;
    }

    private void setSuperClassQualifiedName(String newSuperClassQualifiedName) {
        String oldSuperClassQualifiedName = this.superClassQualifiedName;
        this.superClassQualifiedName = newSuperClassQualifiedName;
        this.firePropertyChanged("superClassQualifiedNameProperty", oldSuperClassQualifiedName, newSuperClassQualifiedName);
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    protected void setQualifiedName(String newQualifiedName) {
        String oldQualifiedName = this.qualifiedName;
        this.qualifiedName = newQualifiedName;
        this.firePropertyChanged("qualifiedNameProperty", oldQualifiedName, newQualifiedName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    protected void setAbstract(boolean newAbstract) {
        boolean oldAbstract = this.isAbstract;
        this.isAbstract = newAbstract;
        this.firePropertyChanged("abstractProperty", oldAbstract, newAbstract);
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        super.updateFromJava(astRoot);
        this.setQualifiedName(this.qualifiedName(astRoot));
        this.setName(this.name(astRoot));
        this.updateNestedTypes(astRoot);
        this.updatePersistentAttributes(astRoot);
        this.setAccess(this.calculateAccessType());
        this.setSuperClassQualifiedName(this.superClassQualifiedName(astRoot));
        this.setAbstract(this.isAbstract(astRoot));
    }

    @Override
    public void resolveTypes(CompilationUnit astRoot) {
        super.resolveTypes(astRoot);
        this.setSuperClassQualifiedName(this.superClassQualifiedName(astRoot));
        for (JavaResourcePersistentAttribute attribute : this.attributes) {
            attribute.resolveTypes(astRoot);
        }
        for (JavaResourcePersistentType persistentType : this.nestedTypes) {
            persistentType.resolveTypes(astRoot);
        }
    }

    protected boolean isAbstract(CompilationUnit astRoot) {
        return JPTTools.typeIsAbstract(((Type)this.getMember()).getBinding(astRoot));
    }

    protected String qualifiedName(CompilationUnit astRoot) {
        return ((Type)this.getMember()).getBinding(astRoot).getQualifiedName();
    }

    protected String name(CompilationUnit astRoot) {
        return ((Type)this.getMember()).getBinding(astRoot).getName();
    }

    protected void updateNestedTypes(CompilationUnit astRoot) {
        IType[] declaredTypes = ((Type)this.getMember()).jdtTypes();
        ArrayList<JavaResourcePersistentType> nestedTypesToRemove = new ArrayList<JavaResourcePersistentType>(this.nestedTypes);
        IType[] iTypeArray = declaredTypes;
        int n = declaredTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType declaredType = iTypeArray[n2];
            JavaResourcePersistentType nestedType = this.nestedTypeFor(declaredType);
            if (nestedType == null) {
                nestedType = this.addNestedType(declaredType, astRoot);
            } else {
                nestedTypesToRemove.remove(nestedType);
            }
            nestedType.updateFromJava(astRoot);
            ++n2;
        }
        for (JavaResourcePersistentType nestedType : nestedTypesToRemove) {
            this.removeNestedType(nestedType);
        }
    }

    protected void updatePersistentAttributes(CompilationUnit astRoot) {
        ArrayList<JavaResourcePersistentAttribute> persistentAttributesToRemove = new ArrayList<JavaResourcePersistentAttribute>(this.attributes);
        this.updatePersistentFields(astRoot, persistentAttributesToRemove);
        this.updatePersistentProperties(astRoot, persistentAttributesToRemove);
        for (JavaResourcePersistentAttribute persistentAttribute : persistentAttributesToRemove) {
            this.removeAttribute(persistentAttribute);
        }
    }

    protected void updatePersistentFields(CompilationUnit astRoot, List<JavaResourcePersistentAttribute> persistentAttributesToRemove) {
        this.updatePersistentAttributes(astRoot, persistentAttributesToRemove, (IMember[])((Type)this.getMember()).jdtFields());
    }

    protected void updatePersistentProperties(CompilationUnit astRoot, List<JavaResourcePersistentAttribute> persistentAttributesToRemove) {
        this.updatePersistentAttributes(astRoot, persistentAttributesToRemove, (IMember[])((Type)this.getMember()).jdtMethods());
    }

    protected void updatePersistentAttributes(CompilationUnit astRoot, List<JavaResourcePersistentAttribute> persistentAttributesToRemove, IMember[] members) {
        IMember[] iMemberArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IMember member = iMemberArray[n2];
            JavaResourcePersistentAttribute persistentAttribute = this.attributeFor(member);
            if (persistentAttribute == null) {
                persistentAttribute = this.addAttribute(member, astRoot);
            } else {
                persistentAttributesToRemove.remove(persistentAttribute);
            }
            persistentAttribute.updateFromJava(astRoot);
            ++n2;
        }
    }

    @Override
    public boolean hasAnyAttributeAnnotations() {
        for (JavaResourcePersistentAttribute attribute : CollectionTools.iterable(this.attributes())) {
            if (!attribute.hasAnyAnnotation()) continue;
            return true;
        }
        return false;
    }

    private AccessType calculateAccessType() {
        boolean hasPersistableFields = false;
        boolean hasPersistableProperties = false;
        for (JavaResourcePersistentAttribute field : CollectionTools.iterable(this.fields())) {
            hasPersistableFields = true;
            if (!field.hasAnyAnnotation()) continue;
            return AccessType.FIELD;
        }
        for (JavaResourcePersistentAttribute property : CollectionTools.iterable(this.properties())) {
            hasPersistableProperties = true;
            if (!property.hasAnyAnnotation()) continue;
            return AccessType.PROPERTY;
        }
        if (hasPersistableProperties && !hasPersistableFields) {
            return AccessType.PROPERTY;
        }
        return null;
    }

    private String superClassQualifiedName(CompilationUnit astRoot) {
        ITypeBinding typeBinding = ((Type)this.getMember()).getBinding(astRoot);
        if (typeBinding == null) {
            return null;
        }
        ITypeBinding superClassTypeBinding = typeBinding.getSuperclass();
        if (superClassTypeBinding == null) {
            return null;
        }
        return superClassTypeBinding.getQualifiedName();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }
}

