/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.BaseColumnImpl;
import org.eclipse.jpt.core.internal.resource.java.JoinTableImpl;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberIndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.resource.java.NestableJoinColumn;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

public class JoinColumnImpl
extends BaseColumnImpl
implements NestableJoinColumn {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.JoinColumn");
    private final DeclarationAnnotationElementAdapter<String> referencedColumnNameDeclarationAdapter = this.buildStringElementAdapter("referencedColumnName");
    private final AnnotationElementAdapter<String> referencedColumnNameAdapter = this.buildShortCircuitElementAdapter(this.referencedColumnNameDeclarationAdapter);
    private String referencedColumnName;

    public JoinColumnImpl(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, member, daa, annotationAdapter);
    }

    public JoinColumnImpl(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa) {
        this(parent, member, daa, (AnnotationAdapter)new MemberAnnotationAdapter(member, daa));
    }

    public JoinColumnImpl(JavaResourceNode parent, Member member, IndexedDeclarationAnnotationAdapter idaa) {
        this(parent, member, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)new MemberIndexedAnnotationAdapter(member, idaa));
    }

    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.referencedColumnName = this.referencedColumnName(astRoot);
    }

    protected String nameElementName() {
        return "name";
    }

    protected String columnDefinitionElementName() {
        return "columnDefinition";
    }

    protected String tableElementName() {
        return "table";
    }

    protected String uniqueElementName() {
        return "unique";
    }

    protected String nullableElementName() {
        return "nullable";
    }

    protected String insertableElementName() {
        return "insertable";
    }

    protected String updatableElementName() {
        return "updatable";
    }

    public String getAnnotationName() {
        return "javax.persistence.JoinColumn";
    }

    private IndexedAnnotationAdapter getIndexedAnnotationAdapter() {
        return (IndexedAnnotationAdapter)super.getAnnotationAdapter();
    }

    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    public void initializeFrom(NestableAnnotation oldAnnotation) {
        super.initializeFrom(oldAnnotation);
        JoinColumnAnnotation oldColumn = (JoinColumnAnnotation)((Object)oldAnnotation);
        this.setReferencedColumnName(oldColumn.getReferencedColumnName());
    }

    public String getReferencedColumnName() {
        return this.referencedColumnName;
    }

    public void setReferencedColumnName(String newReferencedColumnName) {
        String oldReferencedColumnName = this.referencedColumnName;
        this.referencedColumnName = newReferencedColumnName;
        this.referencedColumnNameAdapter.setValue(newReferencedColumnName);
        this.firePropertyChanged("referencedColumnNameProperty", oldReferencedColumnName, newReferencedColumnName);
    }

    public TextRange getReferencedColumnNameTextRange(CompilationUnit astRoot) {
        return this.elementTextRange(this.referencedColumnNameDeclarationAdapter, astRoot);
    }

    public boolean referencedColumnNameTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.referencedColumnNameDeclarationAdapter, pos, astRoot);
    }

    public void updateFromJava(CompilationUnit astRoot) {
        super.updateFromJava(astRoot);
        this.setReferencedColumnName(this.referencedColumnName(astRoot));
    }

    protected String referencedColumnName(CompilationUnit astRoot) {
        return this.referencedColumnNameAdapter.getValue(astRoot);
    }

    static JoinColumnImpl createJoinColumn(JavaResourceNode parent, Member member) {
        return new JoinColumnImpl(parent, member, DECLARATION_ANNOTATION_ADAPTER);
    }

    static JoinColumnImpl createNestedJoinColumn(JavaResourceNode parent, Member member, int index, DeclarationAnnotationAdapter joinColumnsAdapter) {
        IndexedDeclarationAnnotationAdapter idaa = JoinColumnImpl.buildNestedDeclarationAnnotationAdapter(index, joinColumnsAdapter);
        MemberIndexedAnnotationAdapter annotationAdapter = new MemberIndexedAnnotationAdapter(member, idaa);
        return new JoinColumnImpl(parent, member, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)annotationAdapter);
    }

    private static IndexedDeclarationAnnotationAdapter buildNestedDeclarationAnnotationAdapter(int index, DeclarationAnnotationAdapter joinColumnsAdapter) {
        return new NestedIndexedDeclarationAnnotationAdapter(joinColumnsAdapter, index, "javax.persistence.JoinColumn");
    }

    static NestableJoinColumn createJoinTableJoinColumn(JavaResourceNode parent, Member member, int index) {
        return new JoinColumnImpl(parent, member, JoinColumnImpl.buildJoinTableAnnotationAdapter(index));
    }

    private static IndexedDeclarationAnnotationAdapter buildJoinTableAnnotationAdapter(int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(JoinTableImpl.DECLARATION_ANNOTATION_ADAPTER, "joinColumns", index, "javax.persistence.JoinColumn");
    }

    static NestableJoinColumn createJoinTableInverseJoinColumn(JavaResourceNode parent, Member member, int index) {
        return new JoinColumnImpl(parent, member, JoinColumnImpl.buildJoinTableInverseAnnotationAdapter(index));
    }

    private static IndexedDeclarationAnnotationAdapter buildJoinTableInverseAnnotationAdapter(int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(JoinTableImpl.DECLARATION_ANNOTATION_ADAPTER, "inverseJoinColumns", index, "javax.persistence.JoinColumn");
    }

    static NestableJoinColumn createAssociationOverrideJoinColumn(DeclarationAnnotationAdapter associationOverrideAdapter, JavaResourceNode parent, Member member, int index) {
        return new JoinColumnImpl(parent, member, JoinColumnImpl.buildAssociationOverrideAnnotationAdapter(associationOverrideAdapter, index));
    }

    private static IndexedDeclarationAnnotationAdapter buildAssociationOverrideAnnotationAdapter(DeclarationAnnotationAdapter associationOverrideAdapter, int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(associationOverrideAdapter, "joinColumns", index, "javax.persistence.JoinColumn");
    }

    public static class JoinColumnAnnotationDefinition
    implements AnnotationDefinition {
        private static final JoinColumnAnnotationDefinition INSTANCE = new JoinColumnAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private JoinColumnAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return JoinColumnImpl.createJoinColumn(parent, member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return null;
        }

        public String getAnnotationName() {
            return "javax.persistence.JoinColumn";
        }
    }
}

