/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.JpaAnnotationProvider;
import org.eclipse.jpt.core.internal.resource.java.AbstractJavaResourceNode;
import org.eclipse.jpt.core.internal.resource.java.JavaResourcePersistentTypeImpl;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.JpaCompilationUnit;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.utility.CommandExecutorProvider;

public class JpaCompilationUnitImpl
extends AbstractJavaResourceNode
implements JpaCompilationUnit {
    protected final JpaAnnotationProvider annotationProvider;
    protected final CommandExecutorProvider modifySharedDocumentCommandExecutorProvider;
    protected final AnnotationEditFormatter annotationEditFormatter;
    protected final ICompilationUnit compilationUnit;
    protected JavaResourcePersistentType persistentType;
    public static final String PERSISTENT_TYPE_PROPERTY = "persistentTypeProperty";
    protected final JavaResourceModel javaResourceModel;

    public JpaCompilationUnitImpl(IFile file, JpaAnnotationProvider annotationProvider, CommandExecutorProvider modifySharedDocumentCommandExecutorProvider, AnnotationEditFormatter annotationEditFormatter, JavaResourceModel javaResourceModel) {
        super(null);
        this.annotationProvider = annotationProvider;
        this.modifySharedDocumentCommandExecutorProvider = modifySharedDocumentCommandExecutorProvider;
        this.annotationEditFormatter = annotationEditFormatter;
        this.javaResourceModel = javaResourceModel;
        this.compilationUnit = this.compilationUnitFrom(file);
        this.initialize(JDTTools.buildASTRoot(this.compilationUnit));
    }

    protected ICompilationUnit compilationUnitFrom(IFile file) {
        ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)file);
        try {
            cu.open(null);
        }
        catch (JavaModelException javaModelException) {}
        return cu;
    }

    public void initialize(CompilationUnit astRoot) {
        IType iType = this.compilationUnit.findPrimaryType();
        if (iType != null) {
            this.persistentType = this.buildJavaResourcePersistentType(iType, astRoot);
        }
    }

    protected boolean requiresParent() {
        return false;
    }

    public JpaCompilationUnit getJpaCompilationUnit() {
        return this;
    }

    public JpaAnnotationProvider getAnnotationProvider() {
        return this.annotationProvider;
    }

    public CommandExecutorProvider getModifySharedDocumentCommandExecutorProvider() {
        return this.modifySharedDocumentCommandExecutorProvider;
    }

    public AnnotationEditFormatter getAnnotationEditFormatter() {
        return this.annotationEditFormatter;
    }

    public JavaResourceModel getResourceModel() {
        return this.javaResourceModel;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public JavaResourcePersistentType getJavaPersistentTypeResource(String fullyQualifiedTypeName) {
        if (this.getPersistentType() != null) {
            return this.getPersistentType().getJavaPersistentTypeResource(fullyQualifiedTypeName);
        }
        return null;
    }

    public JavaResourcePersistentType getPersistentType() {
        return this.persistentType;
    }

    protected void setPersistentType(JavaResourcePersistentType newPersistentType) {
        JavaResourcePersistentType oldPersistentType = this.persistentType;
        this.persistentType = newPersistentType;
        this.firePropertyChanged(PERSISTENT_TYPE_PROPERTY, oldPersistentType, newPersistentType);
    }

    private JavaResourcePersistentType buildJavaResourcePersistentType(IType iType, CompilationUnit astRoot) {
        try {
            if (iType.isAnnotation() || iType.isEnum()) {
                return null;
            }
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        return JavaResourcePersistentTypeImpl.buildJavaResourcePersistentType(this, iType, this.getModifySharedDocumentCommandExecutorProvider(), this.getAnnotationEditFormatter(), astRoot);
    }

    public void updateFromJava() {
        this.updateFromJava(JDTTools.buildASTRoot(this.getCompilationUnit()));
    }

    public void updateFromJava(CompilationUnit astRoot) {
        IType iType = this.compilationUnit.findPrimaryType();
        if (iType == null) {
            this.setPersistentType(null);
        } else if (this.getPersistentType() == null) {
            this.setPersistentType(this.buildJavaResourcePersistentType(iType, astRoot));
        } else {
            this.getPersistentType().updateFromJava(astRoot);
        }
    }

    public TextRange getTextRange(CompilationUnit astRoot) {
        return null;
    }

    public void resourceChanged() {
        this.javaResourceModel.resourceChanged();
    }

    public void resolveTypes() {
        if (this.getPersistentType() != null) {
            this.getPersistentType().resolveTypes(JDTTools.buildASTRoot(this.getCompilationUnit()));
        }
    }
}

