/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractRelationshipMappingAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.BooleanExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.ManyToOneAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManyToOneImpl
extends AbstractRelationshipMappingAnnotation
implements ManyToOneAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.ManyToOne");
    private static final DeclarationAnnotationElementAdapter<String> TARGET_ENTITY_ADAPTER = ManyToOneImpl.buildTargetEntityAdapter();
    private static final DeclarationAnnotationElementAdapter<String[]> CASCADE_ADAPTER = ManyToOneImpl.buildCascadeAdapter();
    private static final DeclarationAnnotationElementAdapter<String> FETCH_ADAPTER = ManyToOneImpl.buildFetchAdapter();
    private static final DeclarationAnnotationElementAdapter<Boolean> OPTIONAL_ADAPTER = ManyToOneImpl.buildOptionalAdapter();
    private final AnnotationElementAdapter<Boolean> optionalAdapter = this.buildBooleanAnnotationElementAdapter(OPTIONAL_ADAPTER);
    private Boolean optional;

    protected ManyToOneImpl(JavaResourcePersistentAttribute parent, Attribute attribute) {
        super(parent, attribute, DECLARATION_ANNOTATION_ADAPTER);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.optional = this.optional(astRoot);
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> targetEntityAdapter() {
        return TARGET_ENTITY_ADAPTER;
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String[]> cascadeAdapter() {
        return CASCADE_ADAPTER;
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> fetchAdapter() {
        return FETCH_ADAPTER;
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.ManyToOne";
    }

    @Override
    public Boolean getOptional() {
        return this.optional;
    }

    @Override
    public void setOptional(Boolean newOptional) {
        Boolean oldOptional = this.optional;
        this.optional = newOptional;
        this.optionalAdapter.setValue(newOptional);
        this.firePropertyChanged("optionalProperty", oldOptional, newOptional);
    }

    @Override
    public TextRange getOptionalTextRange(CompilationUnit astRoot) {
        return this.elementTextRange(OPTIONAL_ADAPTER, astRoot);
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        super.updateFromJava(astRoot);
        this.setOptional(this.optional(astRoot));
    }

    protected Boolean optional(CompilationUnit astRoot) {
        return this.optionalAdapter.getValue(astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildTargetEntityAdapter() {
        return ManyToOneImpl.buildTargetEntityAdapter(DECLARATION_ANNOTATION_ADAPTER, "targetEntity");
    }

    private static DeclarationAnnotationElementAdapter<String[]> buildCascadeAdapter() {
        return ManyToOneImpl.buildEnumArrayAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "cascade");
    }

    private static DeclarationAnnotationElementAdapter<String> buildFetchAdapter() {
        return ManyToOneImpl.buildFetchAdapter(DECLARATION_ANNOTATION_ADAPTER, "fetch");
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildOptionalAdapter() {
        return ManyToOneImpl.buildOptionalAdapter(DECLARATION_ANNOTATION_ADAPTER, "optional");
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildOptionalAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter<Boolean>(annotationAdapter, elementName, false, BooleanExpressionConverter.instance());
    }

    public static class ManyToOneAnnotationDefinition
    implements AnnotationDefinition {
        private static final ManyToOneAnnotationDefinition INSTANCE = new ManyToOneAnnotationDefinition();

        public static ManyToOneAnnotationDefinition instance() {
            return INSTANCE;
        }

        private ManyToOneAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new ManyToOneImpl((JavaResourcePersistentAttribute)parent, (Attribute)member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return null;
        }

        public String getAnnotationName() {
            return "javax.persistence.ManyToOne";
        }
    }
}

