/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.resource.java.JoinTableImpl;
import org.eclipse.jpt.core.internal.resource.java.TableGeneratorImpl;
import org.eclipse.jpt.core.internal.resource.java.TableImpl;
import org.eclipse.jpt.core.internal.utility.jdt.AnnotationStringArrayExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberIndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitArrayAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.resource.java.NestableUniqueConstraint;
import org.eclipse.jpt.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueConstraintImpl
extends AbstractResourceAnnotation<Member>
implements NestableUniqueConstraint {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.UniqueConstraint");
    private final DeclarationAnnotationElementAdapter<String[]> columnNamesDeclarationAdapter;
    private final AnnotationElementAdapter<String[]> columnNamesAdapter;
    private final List<String> columnNames;

    public UniqueConstraintImpl(JavaResourceNode parent, Member member, IndexedDeclarationAnnotationAdapter idaa) {
        super(parent, member, idaa, new MemberIndexedAnnotationAdapter(member, idaa));
        this.columnNamesDeclarationAdapter = UniqueConstraintImpl.buildArrayAnnotationElementAdapter(idaa, "columnNames");
        this.columnNamesAdapter = this.buildAnnotationElementAdapter(this.columnNamesDeclarationAdapter);
        this.columnNames = new ArrayList<String>();
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        String[] javaColumnNames = this.columnNamesAdapter.getValue(astRoot);
        int i = 0;
        while (i < javaColumnNames.length) {
            this.columnNames.add(javaColumnNames[i]);
            ++i;
        }
    }

    protected AnnotationElementAdapter<String[]> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String[]> daea) {
        return new ShortCircuitArrayAnnotationElementAdapter((Member)this.getMember(), (DeclarationAnnotationElementAdapter<T[]>)daea);
    }

    protected static DeclarationAnnotationElementAdapter<String[]> buildArrayAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return UniqueConstraintImpl.buildArrayAnnotationElementAdapter(annotationAdapter, elementName, AnnotationStringArrayExpressionConverter.forStrings());
    }

    protected static DeclarationAnnotationElementAdapter<String[]> buildArrayAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String[]> converter) {
        return new ConversionDeclarationAnnotationElementAdapter<String[]>(annotationAdapter, elementName, false, converter);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.UniqueConstraint";
    }

    @Override
    public IndexedAnnotationAdapter getAnnotationAdapter() {
        return (IndexedAnnotationAdapter)super.getAnnotationAdapter();
    }

    @Override
    public void initializeFrom(NestableAnnotation oldAnnotation) {
        UniqueConstraintAnnotation oldUniqueConstraint = (UniqueConstraintAnnotation)((Object)oldAnnotation);
        for (String columnName : CollectionTools.iterable(oldUniqueConstraint.columnNames())) {
            this.addColumnName(columnName);
        }
    }

    @Override
    public ListIterator<String> columnNames() {
        return new CloneListIterator(this.columnNames);
    }

    @Override
    public int columnNamesSize() {
        return this.columnNames.size();
    }

    @Override
    public void addColumnName(String columnName) {
        this.addItemToList(columnName, this.columnNames, "columnNamesList");
        this.columnNamesAdapter.setValue(this.columnNames.toArray(new String[this.columnNames.size()]));
    }

    @Override
    public void removeColumnName(String columnName) {
        this.removeItemFromList(columnName, this.columnNames, "columnNamesList");
        this.columnNamesAdapter.setValue(this.columnNames.toArray(new String[this.columnNames.size()]));
    }

    @Override
    public boolean columnNamesTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.columnNamesDeclarationAdapter, pos, astRoot);
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        this.updateColumnNamesFromJava(astRoot);
    }

    protected void updateColumnNamesFromJava(CompilationUnit astRoot) {
        Object[] javaColumnNames = this.columnNamesAdapter.getValue(astRoot);
        CollectionTools.retainAll(this.columnNames, (Object[])javaColumnNames);
        int i = 0;
        while (i < javaColumnNames.length) {
            Object columnName = javaColumnNames[i];
            if (!this.columnNames.contains(columnName)) {
                this.addColumnName((String)columnName);
            }
            ++i;
        }
    }

    @Override
    public void moveAnnotation(int newIndex) {
        this.getAnnotationAdapter().moveAnnotation(newIndex);
    }

    static NestableUniqueConstraint createSecondaryTableUniqueConstraint(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter declarationAnnotationAdapter, int index) {
        return new UniqueConstraintImpl(parent, member, UniqueConstraintImpl.buildSecondaryTableUniqueConstraintAnnotationAdapter(declarationAnnotationAdapter, index));
    }

    private static IndexedDeclarationAnnotationAdapter buildSecondaryTableUniqueConstraintAnnotationAdapter(DeclarationAnnotationAdapter declarationAnnotationAdapter, int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(declarationAnnotationAdapter, "uniqueConstraints", index, "javax.persistence.UniqueConstraint");
    }

    static NestableUniqueConstraint createJoinTableUniqueConstraint(JavaResourceNode parent, Member member, int index) {
        return new UniqueConstraintImpl(parent, member, UniqueConstraintImpl.buildJoinTableUniqueConstraintAnnotationAdapter(index));
    }

    private static IndexedDeclarationAnnotationAdapter buildJoinTableUniqueConstraintAnnotationAdapter(int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(JoinTableImpl.DECLARATION_ANNOTATION_ADAPTER, "uniqueConstraints", index, "javax.persistence.UniqueConstraint");
    }

    static NestableUniqueConstraint createTableUniqueConstraint(JavaResourceNode parent, Member member, int index) {
        return new UniqueConstraintImpl(parent, member, UniqueConstraintImpl.buildTableUniqueConstraintAnnotationAdapter(index));
    }

    private static IndexedDeclarationAnnotationAdapter buildTableUniqueConstraintAnnotationAdapter(int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(TableImpl.DECLARATION_ANNOTATION_ADAPTER, "uniqueConstraints", index, "javax.persistence.UniqueConstraint");
    }

    static NestableUniqueConstraint createTableGeneratorUniqueConstraint(JavaResourceNode parent, Member member, int index) {
        return new UniqueConstraintImpl(parent, member, UniqueConstraintImpl.buildTableGeneratorUniqueConstraintAnnotationAdapter(index));
    }

    private static IndexedDeclarationAnnotationAdapter buildTableGeneratorUniqueConstraintAnnotationAdapter(int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(TableGeneratorImpl.DECLARATION_ANNOTATION_ADAPTER, "uniqueConstraints", index, "javax.persistence.UniqueConstraint");
    }
}

