/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.synch;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.JptCoreMessages;
import org.eclipse.jpt.core.resource.persistence.PersistenceArtifactEdit;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.PersistenceResource;
import org.eclipse.jpt.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.jpt.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.core.resource.persistence.XmlPersistenceUnit;

public class SynchronizeClassesJob
extends WorkspaceJob {
    private IFile persistenceXmlFile;

    public SynchronizeClassesJob(IFile file) {
        super(JptCoreMessages.SYNCHRONIZE_CLASSES_JOB);
        this.setRule((ISchedulingRule)file.getProject());
        this.persistenceXmlFile = file;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        XmlPersistenceUnit persistenceUnitResource;
        monitor.beginTask(JptCoreMessages.SYNCHRONIZING_CLASSES_TASK, 200);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        JpaProject jpaProject = JptCorePlugin.getJpaProject(this.persistenceXmlFile.getProject());
        PersistenceArtifactEdit persistenceArtifactEdit = PersistenceArtifactEdit.getArtifactEditForWrite(this.persistenceXmlFile.getProject());
        PersistenceResource persistenceResource = persistenceArtifactEdit.getResource(this.persistenceXmlFile);
        monitor.worked(25);
        XmlPersistence persistence = persistenceResource.getPersistence();
        if (persistence == null) {
            persistence = PersistenceFactory.eINSTANCE.createXmlPersistence();
            persistenceResource.getContents().add((Object)persistence);
        }
        if (persistence.getPersistenceUnits().size() > 0) {
            persistenceUnitResource = (XmlPersistenceUnit)persistence.getPersistenceUnits().get(0);
        } else {
            persistenceUnitResource = PersistenceFactory.eINSTANCE.createXmlPersistenceUnit();
            persistenceUnitResource.setName(this.persistenceXmlFile.getProject().getName());
            persistence.getPersistenceUnits().add((Object)persistenceUnitResource);
        }
        persistenceUnitResource.getClasses().clear();
        monitor.worked(25);
        Iterator<IType> stream = jpaProject.annotatedClasses();
        while (stream.hasNext()) {
            XmlJavaClassRef classRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
            classRef.setJavaClass(stream.next().getFullyQualifiedName());
            persistenceUnitResource.getClasses().add((Object)classRef);
        }
        monitor.worked(100);
        try {
            try {
                persistenceResource.save(null);
            }
            catch (IOException ioe) {
                Status status = new Status(4, "org.eclipse.jpt.core", JptCoreMessages.ERROR_WRITING_FILE, (Throwable)ioe);
                persistenceArtifactEdit.dispose();
                monitor.done();
                return status;
            }
        }
        finally {
            persistenceArtifactEdit.dispose();
            monitor.done();
        }
        return Status.OK_STATUS;
    }
}

