/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.utility.jdt;

import java.util.List;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jpt.core.internal.utility.jdt.ASTNodes;
import org.eclipse.jpt.core.internal.utility.jdt.NodeFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTNodeSearchUtil {
    private ASTNodeSearchUtil() {
    }

    public static MethodDeclaration getMethodDeclarationNode(IMethod iMethod, CompilationUnit cuNode) throws JavaModelException {
        return (MethodDeclaration)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode((IMember)iMethod, cuNode), MethodDeclaration.class);
    }

    public static ASTNode getParent(ASTNode node, Class<?> parentClass) {
        while ((node = node.getParent()) != null && !parentClass.isInstance(node)) {
        }
        return node;
    }

    public static AnnotationTypeMemberDeclaration getAnnotationTypeMemberDeclarationNode(IMethod iMethod, CompilationUnit cuNode) throws JavaModelException {
        return (AnnotationTypeMemberDeclaration)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode((IMember)iMethod, cuNode), AnnotationTypeMemberDeclaration.class);
    }

    public static VariableDeclarationFragment getFieldDeclarationFragmentNode(IField iField, CompilationUnit cuNode) throws JavaModelException {
        ASTNode node = ASTNodeSearchUtil.getNameNode((IMember)iField, cuNode);
        if (node instanceof VariableDeclarationFragment) {
            return (VariableDeclarationFragment)node;
        }
        return (VariableDeclarationFragment)ASTNodes.getParent(node, VariableDeclarationFragment.class);
    }

    public static FieldDeclaration getFieldDeclarationNode(IField iField, CompilationUnit cuNode) throws JavaModelException {
        return (FieldDeclaration)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode((IMember)iField, cuNode), FieldDeclaration.class);
    }

    public static EnumConstantDeclaration getEnumConstantDeclaration(IField iField, CompilationUnit cuNode) throws JavaModelException {
        return (EnumConstantDeclaration)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode((IMember)iField, cuNode), EnumConstantDeclaration.class);
    }

    public static EnumDeclaration getEnumDeclarationNode(IType iType, CompilationUnit cuNode) throws JavaModelException {
        return (EnumDeclaration)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode((IMember)iType, cuNode), EnumDeclaration.class);
    }

    public static AnnotationTypeDeclaration getAnnotationTypeDeclarationNode(IType iType, CompilationUnit cuNode) throws JavaModelException {
        return (AnnotationTypeDeclaration)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode((IMember)iType, cuNode), AnnotationTypeDeclaration.class);
    }

    public static BodyDeclaration getBodyDeclarationNode(IMember iMember, CompilationUnit cuNode) throws JavaModelException {
        return (BodyDeclaration)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode(iMember, cuNode), BodyDeclaration.class);
    }

    public static AbstractTypeDeclaration getAbstractTypeDeclarationNode(IType iType, CompilationUnit cuNode) throws JavaModelException {
        return (AbstractTypeDeclaration)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode((IMember)iType, cuNode), AbstractTypeDeclaration.class);
    }

    public static TypeDeclaration getTypeDeclarationNode(IType iType, CompilationUnit cuNode) throws JavaModelException {
        return (TypeDeclaration)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode((IMember)iType, cuNode), TypeDeclaration.class);
    }

    public static ClassInstanceCreation getClassInstanceCreationNode(IType iType, CompilationUnit cuNode) throws JavaModelException {
        return (ClassInstanceCreation)ASTNodes.getParent(ASTNodeSearchUtil.getNameNode((IMember)iType, cuNode), ClassInstanceCreation.class);
    }

    public static List<BodyDeclaration> getBodyDeclarationList(IType iType, CompilationUnit cuNode) throws JavaModelException {
        if (iType.isAnonymous()) {
            return ASTNodeSearchUtil.getClassInstanceCreationNode(iType, cuNode).getAnonymousClassDeclaration().bodyDeclarations();
        }
        return ASTNodeSearchUtil.getAbstractTypeDeclarationNode(iType, cuNode).bodyDeclarations();
    }

    private static ASTNode getNameNode(IMember iMember, CompilationUnit cuNode) throws JavaModelException {
        return NodeFinder.perform((ASTNode)cuNode, iMember.getNameRange());
    }
}

