/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.utility.jdt;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.utility.internal.StringTools;

public abstract class AbstractAnnotationAdapter
implements AnnotationAdapter {
    private final Member member;
    private final DeclarationAnnotationAdapter daa;

    public AbstractAnnotationAdapter(Member member, DeclarationAnnotationAdapter daa) {
        this.member = member;
        this.daa = daa;
    }

    public Annotation getAnnotation() {
        return this.daa.getAnnotation(this.member.getModifiedDeclaration());
    }

    public Annotation getAnnotation(CompilationUnit astRoot) {
        return this.daa.getAnnotation(this.member.getModifiedDeclaration(astRoot));
    }

    public void newMarkerAnnotation() {
        this.edit(this.buildNewMarkerAnnotationEditor());
    }

    public void newSingleMemberAnnotation() {
        this.edit(this.buildNewSingleMemberAnnotationEditor());
    }

    public void newNormalAnnotation() {
        this.edit(this.buildNewNormalAnnotationEditor());
    }

    public void removeAnnotation() {
        this.edit(this.buildRemoveAnnotationEditor());
    }

    public ASTNode getAstNode() {
        return this.daa.getAstNode(this.member.getModifiedDeclaration());
    }

    public ASTNode getAstNode(CompilationUnit astRoot) {
        return this.daa.getAstNode(this.member.getModifiedDeclaration(astRoot));
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.daa);
    }

    protected void edit(Member.Editor editor) {
        this.member.edit(editor);
    }

    protected Member.Editor buildNewMarkerAnnotationEditor() {
        return new NewMarkerAnnotationEditor(this.daa);
    }

    protected Member.Editor buildNewSingleMemberAnnotationEditor() {
        return new NewSingleMemberAnnotationEditor(this.daa);
    }

    protected Member.Editor buildNewNormalAnnotationEditor() {
        return new NewNormalAnnotationEditor(this.daa);
    }

    protected Member.Editor buildRemoveAnnotationEditor() {
        return new RemoveAnnotationEditor(this.daa);
    }

    protected static class NewMarkerAnnotationEditor
    implements Member.Editor {
        private final DeclarationAnnotationAdapter daa;

        NewMarkerAnnotationEditor(DeclarationAnnotationAdapter daa) {
            this.daa = daa;
        }

        public void edit(ModifiedDeclaration declaration) {
            this.daa.newMarkerAnnotation(declaration);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }

    protected static class NewNormalAnnotationEditor
    implements Member.Editor {
        private final DeclarationAnnotationAdapter daa;

        NewNormalAnnotationEditor(DeclarationAnnotationAdapter daa) {
            this.daa = daa;
        }

        public void edit(ModifiedDeclaration declaration) {
            this.daa.newNormalAnnotation(declaration);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }

    protected static class NewSingleMemberAnnotationEditor
    implements Member.Editor {
        private final DeclarationAnnotationAdapter daa;

        NewSingleMemberAnnotationEditor(DeclarationAnnotationAdapter daa) {
            this.daa = daa;
        }

        public void edit(ModifiedDeclaration declaration) {
            this.daa.newSingleMemberAnnotation(declaration);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }

    protected static class RemoveAnnotationEditor
    implements Member.Editor {
        private final DeclarationAnnotationAdapter daa;

        RemoveAnnotationEditor(DeclarationAnnotationAdapter daa) {
            this.daa = daa;
        }

        public void edit(ModifiedDeclaration declaration) {
            this.daa.removeAnnotation(declaration);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

