/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.utility.jdt;

import java.util.List;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jpt.core.internal.utility.jdt.JDTAttribute;
import org.eclipse.jpt.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.core.utility.jdt.FieldAttribute;
import org.eclipse.jpt.utility.CommandExecutorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTFieldAttribute
extends JDTAttribute
implements FieldAttribute {
    public JDTFieldAttribute(IField field, CommandExecutorProvider modifySharedDocumentCommandExecutorProvider) {
        super((IMember)field, modifySharedDocumentCommandExecutorProvider);
    }

    public JDTFieldAttribute(IField field, CommandExecutorProvider modifySharedDocumentCommandExecutorProvider, AnnotationEditFormatter annotationEditFormatter) {
        super((IMember)field, modifySharedDocumentCommandExecutorProvider, annotationEditFormatter);
    }

    public IField getJdtMember() {
        return (IField)super.getJdtMember();
    }

    public FieldDeclaration getBodyDeclaration(CompilationUnit astRoot) {
        String fieldName = this.name();
        FieldDeclaration[] fieldDeclarationArray = this.declaringTypeDeclaration(astRoot).getFields();
        int n = fieldDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n2];
            for (VariableDeclarationFragment fragment : this.fragments(fieldDeclaration)) {
                if (!fragment.getName().getFullyQualifiedName().equals(fieldName)) continue;
                return fieldDeclaration;
            }
            ++n2;
        }
        return null;
    }

    private VariableDeclarationFragment getFragment(CompilationUnit astRoot) {
        FieldDeclaration fieldDeclaration = this.getBodyDeclaration(astRoot);
        for (VariableDeclarationFragment fragment : this.fragments(fieldDeclaration)) {
            if (!fragment.getName().getFullyQualifiedName().equals(this.name())) continue;
            return fragment;
        }
        return null;
    }

    @Override
    public IVariableBinding getBinding(CompilationUnit astRoot) {
        return this.getFragment(astRoot).resolveBinding();
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public String getAttributeName() {
        return this.name();
    }

    @Override
    public ITypeBinding getTypeBinding(CompilationUnit astRoot) {
        return this.getBodyDeclaration(astRoot).getType().resolveBinding();
    }

    protected List<VariableDeclarationFragment> fragments(FieldDeclaration fd) {
        return fd.fragments();
    }
}

