/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.utility.jdt;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jpt.core.internal.utility.SimpleTextRange;
import org.eclipse.jpt.core.internal.utility.jdt.ASTNodeTextRange;
import org.eclipse.jpt.core.internal.utility.jdt.DefaultAnnotationEditFormatter;
import org.eclipse.jpt.core.internal.utility.jdt.JDTModifiedDeclaration;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.core.internal.utility.jdt.JDTType;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.utility.Command;
import org.eclipse.jpt.utility.CommandExecutor;
import org.eclipse.jpt.utility.CommandExecutorProvider;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JDTMember
implements Member {
    private final IMember jdtMember;
    private final Type declaringType;
    private final CommandExecutorProvider modifySharedDocumentCommandExecutorProvider;
    private final AnnotationEditFormatter annotationEditFormatter;

    JDTMember(IMember jdtMember, CommandExecutorProvider modifySharedDocumentCommandExecutorProvider) {
        this(jdtMember, modifySharedDocumentCommandExecutorProvider, DefaultAnnotationEditFormatter.instance());
    }

    JDTMember(IMember jdtMember, CommandExecutorProvider modifySharedDocumentCommandExecutorProvider, AnnotationEditFormatter annotationEditFormatter) {
        this.jdtMember = jdtMember;
        IType jdtDeclaringType = jdtMember.getDeclaringType();
        this.declaringType = jdtDeclaringType == null ? null : new JDTType(jdtDeclaringType, modifySharedDocumentCommandExecutorProvider);
        this.modifySharedDocumentCommandExecutorProvider = modifySharedDocumentCommandExecutorProvider;
        this.annotationEditFormatter = annotationEditFormatter;
    }

    @Override
    public IMember getJdtMember() {
        return this.jdtMember;
    }

    @Override
    public boolean wraps(IMember member) {
        return this.jdtMember.exists() && this.jdtMember.equals(member);
    }

    public Type declaringType() {
        return this.declaringType;
    }

    public ICompilationUnit compilationUnit() {
        return this.jdtMember.getCompilationUnit();
    }

    public String name() {
        return this.jdtMember.getElementName();
    }

    @Override
    public Type getTopLevelDeclaringType() {
        return this.declaringType.getTopLevelDeclaringType();
    }

    @Override
    public CompilationUnit getAstRoot() {
        return JDTTools.buildASTRoot(this.jdtMember);
    }

    private CompilationUnit lightweightASTRoot() {
        return JDTTools.buildLightweightASTRoot(this.jdtMember);
    }

    @Override
    public ModifiedDeclaration getModifiedDeclaration() {
        return this.getModifiedDeclaration(this.getAstRoot());
    }

    @Override
    public ModifiedDeclaration getModifiedDeclaration(CompilationUnit astRoot) {
        return new JDTModifiedDeclaration(this.getBodyDeclaration(astRoot));
    }

    public TextRange textRange() {
        return this.getTextRange(this.lightweightASTRoot());
    }

    @Override
    public TextRange getTextRange(CompilationUnit astRoot) {
        return this.textRange((ASTNode)this.getBodyDeclaration(astRoot));
    }

    TextRange textRange(ASTNode astNode) {
        return astNode == null ? null : new ASTNodeTextRange(astNode);
    }

    public TextRange nameTextRange() {
        return this.getNameTextRange(this.lightweightASTRoot());
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        ISourceRange sourceRange = this.nameSourceRange();
        return new SimpleTextRange(sourceRange.getOffset(), sourceRange.getLength(), astRoot.getLineNumber(sourceRange.getOffset()));
    }

    private ISourceRange nameSourceRange() {
        try {
            return this.jdtMember.getNameRange();
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.name());
    }

    public Annotation annotation(DeclarationAnnotationAdapter adapter, CompilationUnit astRoot) {
        return adapter.getAnnotation(this.getModifiedDeclaration(astRoot));
    }

    public Annotation annotation(DeclarationAnnotationAdapter adapter) {
        return this.annotation(adapter, this.getAstRoot());
    }

    public boolean containsAnnotation(DeclarationAnnotationAdapter adapter, CompilationUnit astRoot) {
        return this.annotation(adapter, astRoot) != null;
    }

    public boolean containsAnnotation(DeclarationAnnotationAdapter adapter) {
        return this.containsAnnotation(adapter, this.getAstRoot());
    }

    public boolean containsAnyAnnotation(DeclarationAnnotationAdapter[] adapters) {
        return this.containsAnyAnnotation(adapters, this.getAstRoot());
    }

    public boolean containsAnyAnnotation(DeclarationAnnotationAdapter[] adapters, CompilationUnit astRoot) {
        DeclarationAnnotationAdapter[] declarationAnnotationAdapterArray = adapters;
        int n = adapters.length;
        int n2 = 0;
        while (n2 < n) {
            DeclarationAnnotationAdapter adapter = declarationAnnotationAdapterArray[n2];
            if (this.containsAnnotation(adapter, astRoot)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public TextRange getAnnotationTextRange(DeclarationAnnotationAdapter adapter, CompilationUnit astRoot) {
        return this.textRange((ASTNode)this.annotation(adapter, astRoot));
    }

    public TextRange annotationTextRange(DeclarationAnnotationAdapter adapter) {
        return this.getAnnotationTextRange(adapter, this.getAstRoot());
    }

    public ASTNode annotationASTNode(DeclarationAnnotationAdapter adapter, CompilationUnit astRoot) {
        return adapter.getAstNode(this.getModifiedDeclaration(astRoot));
    }

    public ASTNode annotationASTNode(DeclarationAnnotationAdapter adapter) {
        return this.annotationASTNode(adapter, this.getAstRoot());
    }

    @Override
    public void newMarkerAnnotation(final DeclarationAnnotationAdapter adapter) {
        this.edit(new Member.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                adapter.newMarkerAnnotation(declaration);
            }
        });
    }

    public void newSingleMemberAnnotation(final DeclarationAnnotationAdapter adapter) {
        this.edit(new Member.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                adapter.newSingleMemberAnnotation(declaration);
            }
        });
    }

    public void newNormalAnnotation(final DeclarationAnnotationAdapter adapter) {
        this.edit(new Member.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                adapter.newNormalAnnotation(declaration);
            }
        });
    }

    public void removeAnnotation(final DeclarationAnnotationAdapter adapter) {
        this.edit(new Member.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                adapter.removeAnnotation(declaration);
            }
        });
    }

    public <T> T annotationElementValue(DeclarationAnnotationElementAdapter<T> adapter, CompilationUnit astRoot) {
        return adapter.getValue(this.getModifiedDeclaration(astRoot));
    }

    public <T> T annotationElementValue(DeclarationAnnotationElementAdapter<T> adapter) {
        return this.annotationElementValue(adapter, this.getAstRoot());
    }

    public Expression annotationElementExpression(DeclarationAnnotationElementAdapter<?> adapter, CompilationUnit astRoot) {
        return adapter.getExpression(this.getModifiedDeclaration(astRoot));
    }

    public Expression annotationElementExpression(DeclarationAnnotationElementAdapter<?> adapter) {
        return this.annotationElementExpression(adapter, this.getAstRoot());
    }

    public boolean containsAnnotationElement(DeclarationAnnotationElementAdapter<?> adapter, CompilationUnit astRoot) {
        return this.annotationElementExpression(adapter, astRoot) != null;
    }

    public boolean containsAnnotationElement(DeclarationAnnotationElementAdapter<?> adapter) {
        return this.containsAnnotationElement(adapter, this.getAstRoot());
    }

    @Override
    public TextRange getAnnotationElementTextRange(DeclarationAnnotationElementAdapter<?> adapter, CompilationUnit astRoot) {
        return this.textRange((ASTNode)this.annotationElementExpression(adapter, astRoot));
    }

    public TextRange annotationElementTextRange(DeclarationAnnotationElementAdapter<?> adapter) {
        return this.getAnnotationElementTextRange(adapter, this.getAstRoot());
    }

    public ASTNode annotationElementASTNode(DeclarationAnnotationElementAdapter<?> adapter, CompilationUnit astRoot) {
        return adapter.getAstNode(this.getModifiedDeclaration(astRoot));
    }

    public ASTNode annotationElementASTNode(DeclarationAnnotationElementAdapter<?> adapter) {
        return this.annotationElementASTNode(adapter, this.getAstRoot());
    }

    public <T> void setAnnotationElementValue(final DeclarationAnnotationElementAdapter<T> adapter, final T value) {
        this.edit(new Member.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                adapter.setValue(value, declaration);
            }
        });
    }

    @Override
    public void edit(Member.Editor editor) {
        try {
            this.edit_(editor);
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void edit_(Member.Editor editor) throws JavaModelException, BadLocationException {
        ITextFileBuffer buffer;
        ICompilationUnit compilationUnit = this.compilationUnit();
        if (!compilationUnit.isWorkingCopy()) {
            compilationUnit.becomeWorkingCopy(null);
        }
        boolean sharedDocument = (buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(compilationUnit.getResource().getFullPath(), LocationKind.NORMALIZE)) != null;
        IDocument doc = sharedDocument ? buffer.getDocument() : new Document(compilationUnit.getBuffer().getContents());
        CompilationUnit astRoot = this.getAstRoot();
        astRoot.recordModifications();
        editor.edit(this.getModifiedDeclaration(astRoot));
        TextEdit edits = astRoot.rewrite(doc, compilationUnit.getJavaProject().getOptions(true));
        if (sharedDocument) {
            this.getModifySharedDocumentCommandExecutor().execute((Command)new ModifySharedDocumentCommand(edits, doc));
        } else {
            this.applyEdits(edits, doc);
        }
        if (!sharedDocument) {
            compilationUnit.getBuffer().setContents(doc.get());
            compilationUnit.commitWorkingCopy(true, null);
            compilationUnit.discardWorkingCopy();
        }
    }

    void applyEdits(TextEdit edits, IDocument doc) throws MalformedTreeException, BadLocationException {
        edits.apply(doc, 2);
        this.getAnnotationEditFormatter().format(doc, edits);
    }

    private AnnotationEditFormatter getAnnotationEditFormatter() {
        return this.annotationEditFormatter;
    }

    private CommandExecutor getModifySharedDocumentCommandExecutor() {
        return this.modifySharedDocumentCommandExecutorProvider.getCommandExecutor();
    }

    class ModifySharedDocumentCommand
    implements Command {
        private final TextEdit edits;
        private final IDocument doc;

        ModifySharedDocumentCommand(TextEdit edits, IDocument doc) {
            this.edits = edits;
            this.doc = doc;
        }

        public void execute() {
            try {
                JDTMember.this.applyEdits(this.edits, this.doc);
            }
            catch (MalformedTreeException ex) {
                throw new RuntimeException(ex);
            }
            catch (BadLocationException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

