/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.utility.jdt;

import java.beans.Introspector;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jpt.core.internal.utility.jdt.ASTNodeSearchUtil;
import org.eclipse.jpt.core.internal.utility.jdt.JDTAttribute;
import org.eclipse.jpt.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.core.utility.jdt.MethodAttribute;
import org.eclipse.jpt.utility.CommandExecutorProvider;

public class JDTMethodAttribute
extends JDTAttribute
implements MethodAttribute {
    public JDTMethodAttribute(IMethod getMethod, CommandExecutorProvider modifySharedDocumentCommandExecutorProvider) {
        super((IMember)getMethod, modifySharedDocumentCommandExecutorProvider);
    }

    public JDTMethodAttribute(IMethod getMethod, CommandExecutorProvider modifySharedDocumentCommandExecutorProvider, AnnotationEditFormatter annotationEditFormatter) {
        super((IMember)getMethod, modifySharedDocumentCommandExecutorProvider, annotationEditFormatter);
    }

    public IMethod getJdtMember() {
        return (IMethod)super.getJdtMember();
    }

    public MethodDeclaration getBodyDeclaration(CompilationUnit astRoot) {
        try {
            return ASTNodeSearchUtil.getMethodDeclarationNode(this.getJdtMember(), astRoot);
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    public IMethodBinding getBinding(CompilationUnit astRoot) {
        return this.getBodyDeclaration(astRoot).resolveBinding();
    }

    public boolean isMethod() {
        return true;
    }

    public String getAttributeName() {
        String methodName = super.name();
        int beginIndex = 0;
        if (methodName.startsWith("get")) {
            beginIndex = 3;
        } else if (methodName.startsWith("is")) {
            beginIndex = 2;
        }
        return Introspector.decapitalize(methodName.substring(beginIndex));
    }

    public ITypeBinding getTypeBinding(CompilationUnit astRoot) {
        IMethodBinding methodBinding = this.getBodyDeclaration(astRoot).resolveBinding();
        if (methodBinding != null) {
            return methodBinding.getReturnType();
        }
        return null;
    }
}

