/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.utility.jdt;

import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.TypeLiteral;

public class JDTTools {
    public static CompilationUnit buildLightweightASTRoot(IMember member) {
        return JDTTools.buildASTRoot(member, false);
    }

    public static CompilationUnit buildASTRoot(IMember member) {
        return JDTTools.buildASTRoot(member, true);
    }

    private static CompilationUnit buildASTRoot(IMember member, boolean resolveBindings) {
        return member.isBinary() ? JDTTools.buildASTRoot(member.getClassFile(), resolveBindings) : JDTTools.buildASTRoot(member.getCompilationUnit(), resolveBindings);
    }

    public static CompilationUnit buildASTRoot(IClassFile classFile) {
        return JDTTools.buildASTRoot(classFile, true);
    }

    private static CompilationUnit buildASTRoot(IClassFile classFile, boolean resolveBindings) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(classFile);
        parser.setResolveBindings(resolveBindings);
        return (CompilationUnit)parser.createAST(null);
    }

    public static CompilationUnit buildASTRoot(ICompilationUnit compilationUnit) {
        return JDTTools.buildASTRoot(compilationUnit, true);
    }

    private static CompilationUnit buildASTRoot(ICompilationUnit compilationUnit, boolean resolveBindings) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(compilationUnit);
        parser.setResolveBindings(resolveBindings);
        parser.setBindingsRecovery(true);
        return (CompilationUnit)parser.createAST(null);
    }

    public static String resolveEnum(Expression expression) {
        if (expression == null) {
            return null;
        }
        switch (expression.getNodeType()) {
            case 40: 
            case 42: {
                return JDTTools.resolveEnum((Name)expression);
            }
        }
        return null;
    }

    public static String resolveEnum(Name enumExpression) {
        IBinding binding = enumExpression.resolveBinding();
        if (binding == null) {
            return null;
        }
        if (binding.getKind() != 3) {
            return null;
        }
        IVariableBinding variableBinding = (IVariableBinding)binding;
        return String.valueOf(variableBinding.getType().getQualifiedName()) + "." + variableBinding.getName();
    }

    public static String resolveAnnotation(Annotation node) {
        IAnnotationBinding annotationBinding = node.resolveAnnotationBinding();
        if (annotationBinding == null) {
            return null;
        }
        ITypeBinding annotationTypeBinding = annotationBinding.getAnnotationType();
        if (annotationTypeBinding == null) {
            return null;
        }
        return annotationTypeBinding.getQualifiedName();
    }

    public static String resolveFullyQualifiedName(Expression expression) {
        ITypeBinding resolvedTypeBinding;
        if (expression.getNodeType() == 57 && (resolvedTypeBinding = ((TypeLiteral)expression).getType().resolveBinding()) != null) {
            return resolvedTypeBinding.getQualifiedName();
        }
        return null;
    }
}

