/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.utility.jdt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jpt.core.internal.utility.jdt.JDTMember;
import org.eclipse.jpt.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.utility.CommandExecutorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTType
extends JDTMember
implements Type {
    public JDTType(IType type, CommandExecutorProvider modifySharedDocumentCommandExecutorProvider) {
        super((IMember)type, modifySharedDocumentCommandExecutorProvider);
    }

    public JDTType(IType type, CommandExecutorProvider modifySharedDocumentCommandExecutorProvider, AnnotationEditFormatter annotationEditFormatter) {
        super((IMember)type, modifySharedDocumentCommandExecutorProvider, annotationEditFormatter);
    }

    public IType getJdtMember() {
        return (IType)super.getJdtMember();
    }

    @Override
    public Type getTopLevelDeclaringType() {
        return this.declaringType() == null ? this : super.getTopLevelDeclaringType();
    }

    @Override
    public IType[] jdtTypes() {
        try {
            return this.getJdtMember().getTypes();
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IField[] jdtFields() {
        try {
            return this.getJdtMember().getFields();
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IMethod[] jdtMethods() {
        try {
            return this.getJdtMember().getMethods();
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public AbstractTypeDeclaration getBodyDeclaration(CompilationUnit astRoot) {
        Type declaringType = this.declaringType();
        if (declaringType != null) {
            return this.getTypeDeclaration(declaringType.getBodyDeclaration(astRoot));
        }
        return this.getTypeDeclaration(this.types(astRoot));
    }

    public AbstractTypeDeclaration getTypeDeclaration(AbstractTypeDeclaration declaringTypeDeclaration) {
        return this.getTypeDeclaration(this.types(declaringTypeDeclaration));
    }

    private AbstractTypeDeclaration getTypeDeclaration(List<AbstractTypeDeclaration> typeDeclarations) {
        String name = this.name();
        for (AbstractTypeDeclaration typeDeclaration : typeDeclarations) {
            if (!typeDeclaration.getName().getFullyQualifiedName().equals(name)) continue;
            return typeDeclaration;
        }
        return null;
    }

    @Override
    public ITypeBinding getBinding(CompilationUnit astRoot) {
        return this.getBodyDeclaration(astRoot).resolveBinding();
    }

    protected List<AbstractTypeDeclaration> types(CompilationUnit astRoot) {
        return astRoot.types();
    }

    protected List<AbstractTypeDeclaration> types(AbstractTypeDeclaration typeDeclaration) {
        ArrayList<AbstractTypeDeclaration> typeDeclarations = new ArrayList<AbstractTypeDeclaration>();
        for (BodyDeclaration bodyDeclaration : this.bodyDeclarations(typeDeclaration)) {
            if (bodyDeclaration.getNodeType() != 55 && bodyDeclaration.getNodeType() != 81 && bodyDeclaration.getNodeType() != 71) continue;
            typeDeclarations.add((AbstractTypeDeclaration)bodyDeclaration);
        }
        return typeDeclarations;
    }

    protected List<BodyDeclaration> bodyDeclarations(AbstractTypeDeclaration typeDeclaration) {
        return typeDeclaration.bodyDeclarations();
    }
}

