/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.utility.jdt;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberAnnotationElementAdapter<T>
implements AnnotationElementAdapter<T> {
    private final Member member;
    private final DeclarationAnnotationElementAdapter<T> daea;

    public MemberAnnotationElementAdapter(Member member, DeclarationAnnotationElementAdapter<T> daea) {
        this.member = member;
        this.daea = daea;
    }

    @Override
    public T getValue() {
        return this.daea.getValue(this.member.getModifiedDeclaration());
    }

    @Override
    public T getValue(CompilationUnit astRoot) {
        return this.daea.getValue(this.member.getModifiedDeclaration(astRoot));
    }

    @Override
    public void setValue(T value) {
        this.edit(this.buildSetValueEditor(value));
    }

    @Override
    public Expression getExpression() {
        return this.daea.getExpression(this.member.getModifiedDeclaration());
    }

    @Override
    public Expression getExpression(CompilationUnit astRoot) {
        return this.daea.getExpression(this.member.getModifiedDeclaration(astRoot));
    }

    @Override
    public ASTNode getAstNode() {
        return this.daea.getAstNode(this.member.getModifiedDeclaration());
    }

    @Override
    public ASTNode getAstNode(CompilationUnit astRoot) {
        return this.daea.getAstNode(this.member.getModifiedDeclaration(astRoot));
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, this.daea);
    }

    protected void edit(Member.Editor editor) {
        this.member.edit(editor);
    }

    protected Member.Editor buildSetValueEditor(T value) {
        return new SetValueEditor<T>(value, this.daea);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SetValueEditor<T>
    implements Member.Editor {
        private final DeclarationAnnotationElementAdapter<T> daea;
        private final T value;

        SetValueEditor(T value, DeclarationAnnotationElementAdapter<T> daea) {
            this.value = value;
            this.daea = daea;
        }

        @Override
        public void edit(ModifiedDeclaration declaration) {
            this.daea.setValue(this.value, declaration);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

