/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.utility.jdt;

import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jpt.core.internal.utility.jdt.GenericVisitor;

public class NodeFinder
extends GenericVisitor {
    private int fStart;
    private int fEnd;
    private ASTNode fCoveringNode;
    private ASTNode fCoveredNode;

    public static ASTNode perform(ASTNode root, int start, int length) {
        NodeFinder finder = new NodeFinder(start, length);
        root.accept((ASTVisitor)finder);
        ASTNode result = finder.getCoveredNode();
        if (result == null || result.getStartPosition() != start || result.getLength() != length) {
            return finder.getCoveringNode();
        }
        return result;
    }

    public static ASTNode perform(ASTNode root, ISourceRange range) {
        return NodeFinder.perform(root, range.getOffset(), range.getLength());
    }

    public NodeFinder(int offset, int length) {
        super(true);
        this.fStart = offset;
        this.fEnd = offset + length;
    }

    protected boolean visitNode(ASTNode node) {
        int nodeStart = node.getStartPosition();
        int nodeEnd = nodeStart + node.getLength();
        if (nodeEnd < this.fStart || this.fEnd < nodeStart) {
            return false;
        }
        if (nodeStart <= this.fStart && this.fEnd <= nodeEnd) {
            this.fCoveringNode = node;
        }
        if (this.fStart <= nodeStart && nodeEnd <= this.fEnd) {
            if (this.fCoveringNode == node) {
                this.fCoveredNode = node;
                return true;
            }
            if (this.fCoveredNode == null) {
                this.fCoveredNode = node;
            }
            return false;
        }
        return true;
    }

    public ASTNode getCoveredNode() {
        return this.fCoveredNode;
    }

    public ASTNode getCoveringNode() {
        return this.fCoveringNode;
    }
}

