/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.resource.common;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.ResourceModelListener;
import org.eclipse.jpt.core.internal.AbstractResourceModel;
import org.eclipse.jpt.core.resource.common.JpaArtifactEdit;
import org.eclipse.jpt.core.resource.common.JpaXmlResource;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelEvent;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelListener;

public abstract class JpaXmlResourceModel
extends AbstractResourceModel {
    protected JpaArtifactEdit artifactEdit;
    protected JpaXmlResource resource;

    protected JpaXmlResourceModel(IFile file) {
        this.artifactEdit = this.buildArtifactEdit(file.getProject());
        this.resource = this.artifactEdit.getResource(file);
        this.resource.setResourceModel(this);
        this.artifactEdit.addListener(this.buildReloadListener(this.resource));
    }

    protected abstract JpaArtifactEdit buildArtifactEdit(IProject var1);

    private EditModelListener buildReloadListener(JpaXmlResource resource) {
        return new ReloadListener(resource);
    }

    public JpaXmlResource getResource() {
        return this.resource;
    }

    public void javaElementChanged(ElementChangedEvent event) {
        this.getResource().javaElementChanged(event);
    }

    public void addResourceModelChangeListener(ResourceModelListener listener) {
        this.getResource().addResourceModelChangeListener(listener);
    }

    public void removeResourceModelChangeListener(ResourceModelListener listener) {
        this.getResource().removeResourceModelChangeListener(listener);
    }

    public void dispose() {
        super.dispose();
        this.artifactEdit.dispose();
    }

    public void resolveTypes() {
    }

    private class ReloadListener
    implements EditModelListener {
        final JpaXmlResource resource;

        ReloadListener(JpaXmlResource resource) {
            this.resource = resource;
        }

        public void editModelChanged(EditModelEvent anEvent) {
            switch (anEvent.getEventCode()) {
                case 7: {
                    if (!anEvent.getChangedResources().contains((Object)this.resource) || this.resource.isLoaded()) break;
                    try {
                        this.resource.load(this.resource.getResourceSet().getLoadOptions());
                    }
                    catch (IOException ioe) {
                        JptCorePlugin.log(ioe);
                    }
                    break;
                }
                case 3: {
                    if (!anEvent.getChangedResources().contains((Object)this.resource)) break;
                    anEvent.getEditModel().removeListener((EditModelListener)this);
                }
            }
        }
    }
}

