/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.java.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.ui.refactoring.RenameSupport;
import org.eclipse.wst.jsdt.web.ui.internal.JsUIMessages;
import org.eclipse.wst.jsdt.web.ui.internal.Logger;
import org.eclipse.wst.jsdt.web.ui.internal.java.refactoring.JSPJavaSelectionProvider;
import org.eclipse.wst.sse.ui.internal.util.PlatformStatusLineUtil;

public class JSPRenameElementActionDelegate
implements IEditorActionDelegate,
IActionDelegate2,
IViewActionDelegate {
    private IEditorPart fEditor;

    public void dispose() {
        this.fEditor = null;
    }

    private IJavaElement getSelectedElement() {
        IJavaElement[] elements;
        IJavaElement element = null;
        if (this.fEditor instanceof ITextEditor && (elements = JSPJavaSelectionProvider.getSelection((ITextEditor)this.fEditor)).length == 1) {
            element = elements[0];
        }
        return element;
    }

    public void init(IAction action) {
        if (action != null) {
            action.setText(JsUIMessages.RenameElement_label);
            action.setToolTipText(JsUIMessages.RenameElement_label);
        }
    }

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        IJavaElement element = this.getSelectedElement();
        if (element != null) {
            RenameSupport renameSupport = null;
            try {
                switch (element.getElementType()) {
                    case 7: {
                        renameSupport = RenameSupport.create((IType)((IType)element), (String)element.getElementName(), (int)1);
                        break;
                    }
                    case 9: {
                        renameSupport = RenameSupport.create((IMethod)((IMethod)element), (String)element.getElementName(), (int)1);
                        break;
                    }
                    case 4: {
                        renameSupport = RenameSupport.create((IPackageFragment)((IPackageFragment)element), (String)element.getElementName(), (int)1);
                    }
                }
                if (renameSupport != null) {
                    renameSupport.openDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                    PlatformStatusLineUtil.clearStatusLine();
                }
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        } else {
            PlatformStatusLineUtil.displayErrorMessage((String)JsUIMessages.JSPRenameElementAction_0);
            PlatformStatusLineUtil.addOneTimeClearListener();
        }
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        PlatformStatusLineUtil.clearStatusLine();
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.fEditor = targetEditor;
    }
}

