/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.java.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.web.core.javascript.search.JsSearchScope;
import org.eclipse.wst.jsdt.web.core.javascript.search.JsSearchSupport;
import org.eclipse.wst.jsdt.web.ui.internal.JsUIMessages;
import org.eclipse.wst.jsdt.web.ui.internal.java.search.JsOccurrencesSearchResult;
import org.eclipse.wst.jsdt.web.ui.internal.java.search.JsSingleFileSearchRequestor;
import org.eclipse.wst.sse.ui.internal.search.BasicSearchQuery;

public class JsSearchQuery
extends BasicSearchQuery {
    private IJavaElement fElement = null;

    public JsSearchQuery(IFile file, IJavaElement element) {
        super(file);
        this.fElement = element;
    }

    public boolean canRerun() {
        return false;
    }

    public boolean canRunInBackground() {
        return true;
    }

    protected IStatus doQuery() {
        this.clearMatches();
        IStatus status = Status.OK_STATUS;
        try {
            JsSearchSupport support = JsSearchSupport.getInstance();
            SearchDocument delegate = support.addJspFile(this.getFile());
            String scopePath = delegate.getPath();
            JsSearchScope singleFileScope = new JsSearchScope(new String[]{this.getFile().getFullPath().toString(), scopePath});
            support.searchRunnable(this.getJavaElement(), (IJavaSearchScope)singleFileScope, (SearchRequestor)new JsSingleFileSearchRequestor(this.getInstance()));
        }
        catch (Exception exception) {
            status = new Status(4, "org.eclipse.wst.sse.ui", 0, "", null);
        }
        return status;
    }

    private String getFilename() {
        String filename = JsUIMessages.OccurrencesSearchQuery_2;
        if (this.getFile() != null) {
            filename = this.getFile().getName();
        }
        return filename;
    }

    public JsSearchQuery getInstance() {
        return this;
    }

    public IJavaElement getJavaElement() {
        return this.fElement;
    }

    public String getLabel() {
        Object[] args = new String[]{this.getSearchText(), this.getOccurrencesCountText(), this.getFilename()};
        return NLS.bind((String)JsUIMessages.OccurrencesSearchQuery_0, (Object[])args);
    }

    private String getOccurrencesCountText() {
        String count = "";
        return count;
    }

    public ISearchResult getSearchResult() {
        return new JsOccurrencesSearchResult((ISearchQuery)this);
    }

    protected String getSearchText() {
        return this.fElement.getElementName();
    }
}

