/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.runtime.internal.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.Decorator;

public abstract class ViewObject
implements Serializable {
    private Map _decorators;
    private Map _adapters;
    private static final long serialVersionUID = 1592205691642453075L;

    public List getAllDecorators() {
        int size = this.getDecoratorMap().size();
        if (size == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList allDecorators = new ArrayList();
        Iterator entryIt = this.getDecoratorMap().entrySet().iterator();
        while (entryIt.hasNext()) {
            Map.Entry entry = entryIt.next();
            List decorators = (List)entry.getValue();
            allDecorators.addAll(decorators);
        }
        return Collections.unmodifiableList(allDecorators);
    }

    public List getDecorators(Class decoratorType) {
        List decorators = (List)this.getDecoratorMap().get(decoratorType);
        if (decorators == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(decorators);
    }

    public void addDecorator(Decorator decorator) {
        if (decorator == null) {
            throw new IllegalArgumentException("Arguments must not be null");
        }
        Class<?> associationType = decorator.getClass();
        this.addDecorator(decorator, associationType);
    }

    public void addDecorator(Decorator decorator, Class associatedType) {
        if (decorator == null || associatedType == null) {
            throw new IllegalArgumentException("Arguments must not be null");
        }
        ArrayList<Decorator> decoratorsByType = (ArrayList<Decorator>)this.getDecoratorMap().get(associatedType);
        if (decoratorsByType == null) {
            decoratorsByType = new ArrayList<Decorator>(2);
            this.getDecoratorMap().put(associatedType, decoratorsByType);
        }
        decoratorsByType.add(decorator);
    }

    public boolean removeDecorator(Decorator decorator, Class associatedType) {
        if (decorator == null || associatedType == null) {
            throw new IllegalArgumentException("Arguments must not be null");
        }
        List decoratorsByType = (List)this.getDecoratorMap().get(associatedType);
        if (decoratorsByType != null) {
            return decoratorsByType.remove(decorator);
        }
        return false;
    }

    public Object getAdapter(Class adapterType) {
        if (adapterType == null) {
            return null;
        }
        Object adapter = this.getAdapterMap().get(adapterType);
        if (adapter == null && adapterType.isInstance(this)) {
            adapter = this;
        }
        return adapter;
    }

    public void addAdapter(Class adapterType, Object adapter) {
        if (adapterType == null || adapter == null) {
            throw new IllegalArgumentException("Arguments must not be null");
        }
        if (!adapterType.isInstance(adapter)) {
            throw new IllegalArgumentException("adapter: " + adapter + " must be cast compatible to class: " + adapterType);
        }
        if (adapterType.isInstance(this)) {
            throw new IllegalArgumentException("this: " + this + " must not already be an instance of class: " + adapterType);
        }
        this.getAdapterMap().put(adapterType, adapter);
    }

    public Object removeAdapter(Class adapterType) {
        return this.getAdapterMap().remove(adapterType);
    }

    public Map getAllAdapters() {
        if (this.getAdapterMap().size() == 0) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(this.getAdapterMap());
    }

    protected Map getDecoratorMap() {
        if (this._decorators == null) {
            this._decorators = new HashMap(4);
        }
        return this._decorators;
    }

    protected Map getAdapterMap() {
        if (this._adapters == null) {
            this._adapters = new HashMap(4);
        }
        return this._adapters;
    }
}

