/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.apache.trinidad.tagsupport.converter.operations;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.converter.operations.AbstractTrinidadTransformOperation;
import org.eclipse.jst.pagedesigner.converter.ConvertPosition;
import org.eclipse.jst.pagedesigner.dtmanager.converter.ITransformOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.TransformOperationFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputTextOperation
extends AbstractTrinidadTransformOperation {
    private static final String STYLE_OUTERELEMENT = "font-family:Arial,Helvetica,Geneva,sans-serif;font-size:10pt;font-weight:normal;color:#000000;";
    private static final String STYLE_LABELTD = "font-family:Arial,Helvetica,Geneva,sans-serif;font-size:10pt;text-align:right;color:#000000;padding:0px 8px 0px 0px;font-weight:normal;";
    private static final String STYLE_REQUIREDSPAN = "color:#669966;font-family:Courier,sans-serif;";
    private static final String STYLE_CONTROLELEMENT = "font-family:Arial,Helvetica,Geneva,sans-serif;font-size:10pt;font-weight:normal;color:#000000;";
    private static final String STYLE_HELPSPAN = "font-family:Arial,Helvetica,Geneva,sans-serif;font-size:8pt;font-weight:normal;color:#669966;";

    public Element transform(Element srcElement, Element curElement) {
        Element outerElement;
        String simple = srcElement.getAttribute("simple");
        if (Boolean.valueOf(simple).booleanValue()) {
            outerElement = this.createElement("span");
        } else {
            outerElement = this.createElement("table");
            this.appendAttribute(outerElement, "cellpadding", "0");
            this.appendAttribute(outerElement, "cellspacing", "0");
            this.appendAttribute(outerElement, "border", "0");
        }
        ITransformOperation operation = TransformOperationFactory.getInstance().getTransformOperation(TransformOperationFactory.OP_CopyAttributeWithRenameOperation, new String[]{"styleClass", "class"});
        operation.transform(srcElement, outerElement);
        this.appendAttribute(outerElement, "style", this.calculateStyle("font-family:Arial,Helvetica,Geneva,sans-serif;font-size:10pt;font-weight:normal;color:#000000;", srcElement, "inlineStyle"));
        if (Boolean.valueOf(simple).booleanValue()) {
            this.appendControl(srcElement, outerElement);
        } else {
            Element tdElement;
            Element trElement = this.appendChildElement("tr", outerElement);
            if (this.isRequired(srcElement) || this.getLabel(srcElement) != null) {
                tdElement = this.appendChildElement("td", trElement);
                this.appendAttribute(tdElement, "style", STYLE_LABELTD);
                if (this.getRows(srcElement) > 1) {
                    this.appendAttribute(tdElement, "valign", "top");
                }
                this.appendAttribute(tdElement, "nowrap", "");
                if (this.isRequired(srcElement)) {
                    Element spanElement = this.appendChildElement("span", tdElement);
                    this.appendAttribute(spanElement, "title", "Required");
                    this.appendAttribute(spanElement, "style", STYLE_REQUIREDSPAN);
                    this.appendChildText("*", spanElement);
                    this.appendChildText(" ", tdElement);
                }
                if (this.getLabel(srcElement) != null) {
                    Element labelElement = this.appendChildElement("label", tdElement);
                    this.appendChildText(this.getLabel(srcElement), labelElement);
                }
            }
            tdElement = this.appendChildElement("td", trElement);
            this.appendAttribute(tdElement, "valign", "top");
            this.appendAttribute(tdElement, "nowrap", "");
            this.appendControl(srcElement, tdElement);
            List<Node> helpFacetChildNodes = this.getHelpFacetChildNodes(srcElement);
            if (helpFacetChildNodes.size() > 0) {
                trElement = this.appendChildElement("tr", outerElement);
                if (this.isRequired(srcElement) || this.getLabel(srcElement) != null) {
                    tdElement = this.appendChildElement("td", trElement);
                }
                tdElement = this.appendChildElement("td", trElement);
                Element spanElement = this.appendChildElement("span", tdElement);
                operation = TransformOperationFactory.getInstance().getTransformOperation(TransformOperationFactory.OP_CopyAttributeWithRenameOperation, new String[]{"styleClass", "class"});
                operation.transform(srcElement, spanElement);
                this.appendAttribute(spanElement, "style", this.calculateStyle(STYLE_HELPSPAN, srcElement, "inlineStyle"));
                Iterator<Node> itHelpFacetChildNodes = helpFacetChildNodes.iterator();
                int curPos = 0;
                while (itHelpFacetChildNodes.hasNext()) {
                    Node curNode = itHelpFacetChildNodes.next();
                    if (curNode instanceof Text) {
                        if (curNode.getNodeValue() != null && curNode.getNodeValue().length() > 0) {
                            this.tagConverterContext.addChild(curNode, new ConvertPosition((Node)spanElement, curPos));
                        }
                    } else {
                        this.tagConverterContext.addChild(curNode, new ConvertPosition((Node)spanElement, curPos));
                    }
                    ++curPos;
                }
            }
        }
        return outerElement;
    }

    private String calculateStyle(String baseStyle, Element srcElement, String styleAttributeName) {
        String srcElementStyle;
        String style = baseStyle;
        if (srcElement != null && styleAttributeName != null && (srcElementStyle = srcElement.getAttribute(styleAttributeName)) != null && srcElementStyle.length() > 0) {
            if (style != null) {
                if (!style.endsWith(";")) {
                    style = String.valueOf(style) + ";";
                }
                style = String.valueOf(style) + srcElementStyle;
            } else {
                style = srcElementStyle;
            }
        }
        return style;
    }

    private void appendControl(Element srcElement, Element parentElement) {
        Element controlElement;
        int rows = this.getRows(srcElement);
        if (rows < 2) {
            controlElement = this.appendChildElement("input", parentElement);
            this.appendAttribute(controlElement, "size", String.valueOf(this.getColumns(srcElement)));
            this.appendAttribute(controlElement, "type", this.getType(srcElement));
            String value = srcElement.getAttribute("value");
            if (value != null) {
                this.appendAttribute(controlElement, "value", value);
            }
        } else {
            controlElement = this.appendChildElement("textarea", parentElement);
            this.appendAttribute(controlElement, "cols", String.valueOf(this.getColumns(srcElement)));
            this.appendAttribute(controlElement, "rows", String.valueOf(this.getRows(srcElement)));
            this.appendAttribute(controlElement, "wrap", this.getWrap(srcElement));
            String value = srcElement.getAttribute("value");
            if (value != null) {
                this.appendChildText(value, controlElement);
            }
        }
        this.appendAttribute(controlElement, "style", this.calculateStyle("font-family:Arial,Helvetica,Geneva,sans-serif;font-size:10pt;font-weight:normal;color:#000000;", srcElement, "contentStyle"));
    }

    private int getRows(Element srcElement) {
        String rowsValue;
        int rows = 1;
        if (srcElement != null && (rowsValue = srcElement.getAttribute("rows")) != null && rowsValue.length() > 0) {
            try {
                rows = Integer.parseInt(rowsValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return rows;
    }

    private int getColumns(Element srcElement) {
        String columnsValue;
        int columns = 30;
        if (srcElement != null && (columnsValue = srcElement.getAttribute("columns")) != null && columnsValue.length() > 0) {
            try {
                columns = Integer.parseInt(columnsValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return columns;
    }

    private String getWrap(Element srcElement) {
        String wrapValue;
        String wrap = "soft";
        if (srcElement != null && (wrapValue = srcElement.getAttribute("wrap")) != null && wrapValue.length() > 0) {
            wrap = wrapValue;
        }
        return wrap;
    }

    private String getType(Element srcElement) {
        String secret;
        String type = "text";
        if (srcElement != null && Boolean.valueOf(secret = srcElement.getAttribute("secret")).booleanValue()) {
            type = "password";
        }
        return type;
    }

    private boolean isRequired(Element srcElement) {
        boolean required = false;
        if (srcElement != null) {
            String requiredVal = srcElement.getAttribute("required");
            String showRequiredVal = srcElement.getAttribute("showRequired");
            required = Boolean.parseBoolean(requiredVal) || Boolean.parseBoolean(showRequiredVal);
        }
        return required;
    }

    private String getLabel(Element srcElement) {
        String label = null;
        if (srcElement != null) {
            String labelAndAccessKeyVal = srcElement.getAttribute("labelAndAccessKey");
            if (labelAndAccessKeyVal != null && labelAndAccessKeyVal.length() > 0) {
                label = labelAndAccessKeyVal;
            } else {
                String labelVal = srcElement.getAttribute("label");
                if (labelVal != null && labelVal.length() > 0) {
                    label = labelVal;
                }
            }
        }
        return label;
    }

    private List<Node> getHelpFacetChildNodes(Element srcElement) {
        List<Node> children = Collections.EMPTY_LIST;
        Element helpFacet = this.getChildFacetByName(srcElement, "help");
        if (helpFacet != null) {
            children = this.getCopyChildrenNodes(helpFacet);
        }
        return children;
    }
}

