/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.apache.trinidad.tagsupport.elementedit;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.ITrinidadConstants;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.TrinidadUtils;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.elementedit.DefaultTrinidadCoreElementEdit;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.core.internal.tld.TagIdentifierFactory;
import org.eclipse.jst.pagedesigner.editpolicies.DragMoveEditPolicy;
import org.eclipse.jst.pagedesigner.editpolicies.ElementResizableEditPolicy;
import org.eclipse.jst.pagedesigner.itemcreation.ItemCreationEditPolicy;
import org.eclipse.jst.pagedesigner.parts.ElementEditPart;
import org.eclipse.jst.pagedesigner.parts.NodeEditPart;
import org.eclipse.jst.pagedesigner.tools.ObjectModeDragTracker;
import org.eclipse.jst.pagedesigner.validation.caret.ActionData;
import org.eclipse.jst.pagedesigner.validation.caret.DefaultPositionRule;
import org.eclipse.jst.pagedesigner.validation.caret.DnDPositionValidator;
import org.eclipse.jst.pagedesigner.validation.caret.DropActionData;
import org.eclipse.jst.pagedesigner.validation.caret.IPositionMediator;
import org.eclipse.jst.pagedesigner.validation.caret.IValidationRule;
import org.eclipse.jst.pagedesigner.validation.caret.Target;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PanelTabbedElementEdit
extends DefaultTrinidadCoreElementEdit {
    public void createEditPolicies(ElementEditPart part) {
        part.installEditPolicy((Object)"Selection Feedback", (EditPolicy)new PanelTabbedElementResizableEditPolicy());
        part.installEditPolicy((Object)"PrimaryDrag Policy", (EditPolicy)new PanelTabbedDragMoveEditPolicy());
        part.installEditPolicy((Object)"Item Creation", (EditPolicy)new PanelTabbedItemCreationEditPolicy());
    }

    private static class OnlyShowDetailItemsRule
    extends DefaultPositionRule {
        public OnlyShowDetailItemsRule(ActionData actionData) {
            super(actionData);
        }

        public boolean isEditable(Target target) {
            if (ITrinidadConstants.TAG_IDENTIFIER_PANELTABBED.isSameTagType(target.getTagWrapper())) {
                return this.isDataDroppable();
            }
            return true;
        }

        private boolean isDataDroppable() {
            DropActionData dropActionData;
            TagIdentifier tagIdentifier;
            ActionData actionData = this.getActionData();
            return actionData instanceof DropActionData && ITrinidadConstants.TAG_IDENTIFIER_SHOWDETAILITEM.isSameTagType(tagIdentifier = (TagIdentifier)(dropActionData = (DropActionData)actionData).getDropData().getTagIdentifiers().get(0));
        }
    }

    public static class PanelTabbedDragMoveEditPolicy
    extends DragMoveEditPolicy {
        protected IPositionMediator createDropChildValidator(DropRequest r) {
            DropActionData.DropData dropData = this.createDropData(r);
            if (dropData != null) {
                DnDPositionValidator validator = new DnDPositionValidator((ActionData)new DropActionData(6, dropData));
                validator.addRule((IValidationRule)new OnlyShowDetailItemsRule(validator.getActionData()));
                return validator;
            }
            return null;
        }
    }

    public static class PanelTabbedElementResizableEditPolicy
    extends ElementResizableEditPolicy {
        public DragTracker getSelectionDragTracker(LocationRequest request) {
            return this.getSelectionTracker(request);
        }

        protected DragTracker getSelectionTracker(LocationRequest request) {
            Node node;
            GraphicalEditPart part = (GraphicalEditPart)this.getHost();
            if (part instanceof NodeEditPart && this.getShowDetailItemCount(node = ((NodeEditPart)part).getDOMNode()) > 0) {
                ObjectModeDragTracker dragTracker = new ObjectModeDragTracker(this.getHost()){

                    protected boolean handleButtonDown(int button) {
                        if (button == 1) {
                            Node node;
                            int tabIndex = PanelTabbedElementResizableEditPolicy.this.getTabIndex(this.getLocation());
                            EditPart editPart = this.getSourceEditPart();
                            if (editPart instanceof ElementEditPart && TrinidadUtils.setCurrentChildIndex(node = ((ElementEditPart)editPart).getDOMNode(), tabIndex)) {
                                ((ElementEditPart)editPart).refresh(true);
                            }
                        }
                        return super.handleButtonDown(button);
                    }
                };
                return dragTracker;
            }
            return new ObjectModeDragTracker(this.getHost());
        }

        private int getTabIndex(Point location) {
            int tabIndex = -1;
            GraphicalEditPart part = (GraphicalEditPart)this.getHost();
            if (part instanceof NodeEditPart) {
                int tabWidth;
                Node node = ((NodeEditPart)part).getDOMNode();
                IFigure figure = part.getFigure();
                Point relLocation = location.getCopy();
                figure.translateToRelative((Translatable)relLocation);
                int showDetailItemCount = this.getShowDetailItemCount(node);
                if (showDetailItemCount > 0 && (tabIndex = relLocation.x / (tabWidth = figure.getBounds().width / showDetailItemCount)) > showDetailItemCount - 1) {
                    tabIndex = showDetailItemCount - 1;
                }
            }
            return tabIndex;
        }

        private int getShowDetailItemCount(Node node) {
            int count = 0;
            if (node != null) {
                NodeList childNodes = node.getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    Node childNode = childNodes.item(i);
                    if (childNode instanceof Element && ITrinidadConstants.TAG_IDENTIFIER_SHOWDETAILITEM.isSameTagType(TagIdentifierFactory.createDocumentTagWrapper((Element)((Element)childNode)))) {
                        ++count;
                    }
                    ++i;
                }
            }
            return count;
        }
    }

    public static class PanelTabbedItemCreationEditPolicy
    extends ItemCreationEditPolicy {
        protected IPositionMediator createDropChildValidator(DropRequest r) {
            DropActionData.DropData dropData = this.createDropData(r);
            if (dropData != null) {
                DnDPositionValidator validator = new DnDPositionValidator((ActionData)new DropActionData(1, dropData));
                validator.addRule((IValidationRule)new OnlyShowDetailItemsRule(validator.getActionData()));
                return validator;
            }
            return null;
        }
    }
}

