/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.refactoring.descriptors;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.wst.jsdt.internal.core.refactoring.descriptors.DescriptorMessages;

public abstract class JavaRefactoringDescriptor
extends RefactoringDescriptor {
    protected static final String ATTRIBUTE_ELEMENT = "element";
    protected static final String ATTRIBUTE_INPUT = "input";
    protected static final String ATTRIBUTE_NAME = "name";
    protected static final String ATTRIBUTE_REFERENCES = "references";
    protected static final String ATTRIBUTE_SELECTION = "selection";
    protected static final String ATTRIBUTE_VERSION = "version";
    public static final int JAR_MIGRATION = 65536;
    public static final int JAR_REFACTORING = 524288;
    public static final int JAR_SOURCE_ATTACHMENT = 262144;
    protected static final String VALUE_VERSION_1_0 = "1.0";
    protected final Map fArguments;

    protected static String elementToHandle(String project, IJavaElement element) {
        String handle = element.getHandleIdentifier();
        if (project != null && !(element instanceof IJavaProject)) {
            String id = element.getJavaProject().getHandleIdentifier();
            return handle.substring(id.length());
        }
        return handle;
    }

    protected static IJavaElement handleToElement(String project, String handle) {
        return JavaRefactoringDescriptor.handleToElement(project, handle, true);
    }

    protected static IJavaElement handleToElement(String project, String handle, boolean check) {
        return JavaRefactoringDescriptor.handleToElement(null, project, handle, check);
    }

    protected static IJavaElement handleToElement(WorkingCopyOwner owner, String project, String handle, boolean check) {
        IJavaElement element = null;
        element = owner != null ? JavaCore.create((String)handle, (WorkingCopyOwner)owner) : JavaCore.create((String)handle);
        if (element == null && project != null) {
            IJavaProject javaProject = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProject(project);
            String identifier = javaProject.getHandleIdentifier();
            element = owner != null ? JavaCore.create((String)(String.valueOf(identifier) + handle), (WorkingCopyOwner)owner) : JavaCore.create((String)(String.valueOf(identifier) + handle));
        }
        if (check && element instanceof IMethod) {
            IMethod[] iMethodArray;
            IMethod method = (IMethod)element;
            if (method.getDeclaringType() != null) {
                iMethodArray = method.getDeclaringType().findMethods(method);
            } else {
                IMethod[] iMethodArray2 = new IMethod[1];
                iMethodArray = iMethodArray2;
                iMethodArray2[0] = method.getCompilationUnit().getMethod(method.getElementName(), method.getParameterTypes());
            }
            IMethod[] methods = iMethodArray;
            if (methods != null && methods.length > 0) {
                element = methods[0];
            }
        }
        if (element != null && (!check || element.exists())) {
            return element;
        }
        return null;
    }

    protected static IResource handleToResource(String project, String handle) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if ("".equals(handle)) {
            return null;
        }
        IPath path = Path.fromPortableString((String)handle);
        if (path == null) {
            return null;
        }
        if (project != null && !"".equals(project)) {
            return root.getProject(project).findMember(path);
        }
        return root.findMember(path);
    }

    protected static String resourceToHandle(String project, IResource resource) {
        if (project != null && !"".equals(project)) {
            return resource.getProjectRelativePath().toPortableString();
        }
        return resource.getFullPath().toPortableString();
    }

    protected JavaRefactoringDescriptor(String id) {
        this(id, new HashMap());
    }

    protected JavaRefactoringDescriptor(String id, Map arguments) {
        super(id, null, DescriptorMessages.JavaRefactoringDescriptor_not_available, null, 6);
        this.fArguments = arguments;
        this.fArguments.put(ATTRIBUTE_VERSION, VALUE_VERSION_1_0);
    }

    public Refactoring createRefactoring(RefactoringStatus status) throws CoreException {
        this.populateArgumentMap();
        Refactoring refactoring = null;
        String id = this.getID();
        RefactoringContribution contribution = RefactoringCore.getRefactoringContribution((String)id);
        if (contribution != null) {
            RefactoringDescriptor descriptor = contribution.createDescriptor(id, this.getProject(), this.getDescription(), this.getComment(), this.fArguments, this.getFlags());
            if (descriptor != null) {
                refactoring = descriptor.createRefactoring(status);
            } else {
                JavaManipulationPlugin.log((IStatus)new Status(4, JavaManipulationPlugin.getPluginId(), 0, MessageFormat.format(DescriptorMessages.JavaRefactoringDescriptor_no_resulting_descriptor, id), null));
            }
        }
        return refactoring;
    }

    protected Map getArguments() {
        this.populateArgumentMap();
        return new HashMap(this.fArguments);
    }

    protected void populateArgumentMap() {
        Assert.isTrue((!this.validateDescriptor().hasFatalError() ? 1 : 0) != 0, (String)"Validation returns a fatal error status.");
    }

    public void setComment(String comment) {
        super.setComment(comment);
    }

    public void setDescription(String description) {
        super.setDescription(description);
    }

    public void setFlags(int flags) {
        super.setFlags(flags);
    }

    public void setProject(String project) {
        super.setProject(project);
    }

    public RefactoringStatus validateDescriptor() {
        RefactoringStatus status = new RefactoringStatus();
        String description = this.getDescription();
        if (description == null || "".equals(description)) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.JavaRefactoringDescriptor_no_description));
        }
        return status;
    }
}

