/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.refactoring.descriptors;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.core.refactoring.descriptors.DescriptorMessages;

public final class RenameResourceDescriptor
extends JavaRefactoringDescriptor {
    private String fName = null;
    private IResource fResource = null;

    public RenameResourceDescriptor() {
        super("org.eclipse.wst.jsdt.ui.rename.resource");
    }

    protected void populateArgumentMap() {
        super.populateArgumentMap();
        this.fArguments.put("input", RenameResourceDescriptor.resourceToHandle(this.getProject(), this.fResource));
        this.fArguments.put("name", this.fName);
    }

    public void setNewName(String name) {
        Assert.isNotNull((Object)name);
        Assert.isLegal((!"".equals(name) ? 1 : 0) != 0, (String)"Name must not be empty");
        this.fName = name;
    }

    public void setProject(String project) {
        super.setProject(project);
    }

    public void setResource(IResource resource) {
        Assert.isNotNull((Object)resource);
        this.fResource = resource;
    }

    public RefactoringStatus validateDescriptor() {
        RefactoringStatus status = super.validateDescriptor();
        if (this.fResource == null) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameResourceDescriptor_no_resource));
        }
        if (this.fName == null || "".equals(this.fName)) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameResourceDescriptor_no_new_name));
        }
        if (this.fResource instanceof IProject && this.getProject() != null) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameResourceDescriptor_project_constraint));
        }
        return status;
    }
}

