/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.manipulation;

import java.util.regex.Pattern;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;

public class JavaElementPropertyTester
extends PropertyTester {
    public static final String NAME = "name";
    public static final String IS_IN_JAVA_PROJECT = "isInJavaProject";
    public static final String IS_IN_JAVA_PROJECT_WITH_NATURE = "isInJavaProjectWithNature";
    public static final String IS_ON_CLASSPATH = "isOnClasspath";
    public static final String HAS_TYPE_ON_CLASSPATH = "hasTypeOnClasspath";
    public static final String IN_SOURCE_FOLDER = "inSourceFolder";
    public static final String IN_ARCHIVE = "inArchive";
    public static final String IN_EXTERNAL_ARCHIVE = "inExternalArchive";
    public static final String PROJECT_OPTION = "projectOption";

    public boolean test(Object receiver, String method, Object[] args, Object expectedValue) {
        IJavaProject javaProject;
        if (!(receiver instanceof IJavaElement)) {
            return false;
        }
        IJavaElement res = (IJavaElement)receiver;
        if (method.equals(NAME)) {
            return Pattern.matches(this.toString(expectedValue), res.getElementName());
        }
        if (method.equals(IS_IN_JAVA_PROJECT)) {
            IJavaProject javaProject2 = res.getJavaProject();
            return javaProject2 != null && javaProject2.exists() && javaProject2.getProject().isOpen();
        }
        if (method.equals(IS_IN_JAVA_PROJECT_WITH_NATURE)) {
            IJavaProject javaProject3 = res.getJavaProject();
            if (javaProject3 != null && javaProject3.exists() && javaProject3.getProject().isOpen() && expectedValue != null) {
                try {
                    return javaProject3.getProject().hasNature(this.toString(expectedValue));
                }
                catch (CoreException coreException) {
                    return false;
                }
            }
            return false;
        }
        if (method.equals(IS_ON_CLASSPATH)) {
            IJavaProject javaProject4 = res.getJavaProject();
            if (javaProject4 != null && javaProject4.exists()) {
                return javaProject4.isOnClasspath(res);
            }
            return false;
        }
        if (method.equals(IN_SOURCE_FOLDER)) {
            IJavaElement root = res.getAncestor(3);
            if (root != null) {
                try {
                    return ((IPackageFragmentRoot)root).getKind() == 1;
                }
                catch (JavaModelException javaModelException) {}
            }
            return false;
        }
        if (method.equals(IN_ARCHIVE)) {
            IJavaElement root = res.getAncestor(3);
            if (root != null) {
                return ((IPackageFragmentRoot)root).isArchive();
            }
            return false;
        }
        if (method.equals(IN_EXTERNAL_ARCHIVE)) {
            IJavaElement root = res.getAncestor(3);
            if (root != null) {
                return ((IPackageFragmentRoot)root).isExternal();
            }
            return false;
        }
        if (method.equals(PROJECT_OPTION)) {
            IJavaProject project = res.getJavaProject();
            if (project != null) {
                if (args.length == 2) {
                    String current = project.getOption(this.toString(args[0]), true);
                    return current != null && current.equals(args[1]);
                }
                if (args.length == 1) {
                    return project.getOption(this.toString(args[0]), false) != null;
                }
            }
            return false;
        }
        if (method.equals(HAS_TYPE_ON_CLASSPATH) && (javaProject = res.getJavaProject()) != null && javaProject.exists()) {
            try {
                return javaProject.findType(this.toString(expectedValue)) != null;
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        return false;
    }

    private String toString(Object expectedValue) {
        return expectedValue == null ? "" : expectedValue.toString();
    }
}

