/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.views.contentoutline;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.dtd.core.internal.AttributeList;
import org.eclipse.wst.dtd.core.internal.CMGroupNode;
import org.eclipse.wst.dtd.core.internal.CMNode;
import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.core.internal.Element;
import org.eclipse.wst.dtd.core.internal.NodeList;
import org.eclipse.wst.dtd.core.internal.document.DTDModelImpl;
import org.eclipse.wst.dtd.core.internal.util.LabelValuePair;
import org.eclipse.wst.dtd.ui.internal.DTDUIMessages;
import org.eclipse.wst.dtd.ui.internal.editor.DTDEditorPluginImageHelper;
import org.eclipse.wst.dtd.ui.internal.views.contentoutline.actions.AddAttributeAction;
import org.eclipse.wst.dtd.ui.internal.views.contentoutline.actions.AddAttributeListAction;
import org.eclipse.wst.dtd.ui.internal.views.contentoutline.actions.AddCommentAction;
import org.eclipse.wst.dtd.ui.internal.views.contentoutline.actions.AddElementAction;
import org.eclipse.wst.dtd.ui.internal.views.contentoutline.actions.AddElementToContentModelAction;
import org.eclipse.wst.dtd.ui.internal.views.contentoutline.actions.AddEntityAction;
import org.eclipse.wst.dtd.ui.internal.views.contentoutline.actions.AddGroupToContentModelAction;
import org.eclipse.wst.dtd.ui.internal.views.contentoutline.actions.AddNotationAction;
import org.eclipse.wst.dtd.ui.internal.views.contentoutline.actions.AddParameterEntityReferenceAction;
import org.eclipse.wst.dtd.ui.internal.views.contentoutline.actions.DeleteAction;
import org.eclipse.wst.dtd.ui.internal.views.contentoutline.actions.ReplaceEmptyContentModelWithGroupAction;

class DTDContextMenuHelper {
    AddAttributeAction addAttributeAction;
    AddAttributeListAction addAttributeListAction;
    AddCommentAction addCommentAction;
    AddElementAction addElementAction;
    AddElementToContentModelAction addElementToContentModelAction;
    AddEntityAction addEntityAction;
    AddGroupToContentModelAction addGroupToContentModelAction;
    AddNotationAction addNotationAction;
    AddParameterEntityReferenceAction addParameterEntityReferenceAction;
    DeleteAction deleteAction;
    private ISelectionChangedListener fInternalSelectionChangedListener = new ViewerSelectionChangeListener();
    private IMenuListener fMenuListener;
    private DTDModelImpl fModel;
    private List fViewerList;
    IStructuredSelection fViewerSelection = StructuredSelection.EMPTY;
    ReplaceEmptyContentModelWithGroupAction replaceEmptyContentModelWithGroupAction;

    public DTDContextMenuHelper(DTDModelImpl model) {
        this.fModel = model;
        this.fViewerList = new ArrayList(1);
        this.fMenuListener = new DTDMenuListener();
        this.addNotationAction = new AddNotationAction(model, DTDUIMessages._UI_ACTION_ADD_DTD_NOTATION);
        this.addEntityAction = new AddEntityAction(model, DTDUIMessages._UI_ACTION_ADD_DTD_ENTITY);
        this.addElementAction = new AddElementAction(model, DTDUIMessages._UI_ACTION_ADD_DTD_ELEMENT);
        this.addCommentAction = new AddCommentAction(model, DTDUIMessages._UI_ACTION_ADD_DTD_COMMENT);
        this.addParameterEntityReferenceAction = new AddParameterEntityReferenceAction(model, DTDUIMessages._UI_ACTION_ADD_PARAM_ENTITY_REF);
        this.deleteAction = new DeleteAction(DTDUIMessages._UI_ACTION_DTD_DELETE);
        this.addAttributeAction = new AddAttributeAction(model, DTDUIMessages._UI_ACTION_ADD_ATTRIBUTE);
        this.addAttributeListAction = new AddAttributeListAction(model, DTDUIMessages._UI_ACTION_ADD_ATTRIBUTELIST);
        this.addGroupToContentModelAction = new AddGroupToContentModelAction(model, DTDUIMessages._UI_ACTION_GROUP_ADD_GROUP);
        this.addElementToContentModelAction = new AddElementToContentModelAction(model, DTDUIMessages._UI_ACTION_ADD_ELEMENT);
        this.replaceEmptyContentModelWithGroupAction = new ReplaceEmptyContentModelWithGroupAction(model, DTDUIMessages._UI_ACTION_GROUP_ADD_GROUP);
        this.addNotationAction.setImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/ADD_Notation.gif"));
        this.addEntityAction.setImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/ADD_Entity.gif"));
        this.addCommentAction.setImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/ADD_Comment.gif"));
        this.addParameterEntityReferenceAction.setImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/ADD_Entity_Reference.gif"));
        this.addElementAction.setImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/etool16/ADD_Element.gif"));
        this.addElementAction.setHoverImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/ctool16/ADD_Element.gif"));
        this.addElementAction.setDisabledImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/dtool16/ADD_Element.gif"));
        this.addAttributeAction.setImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/etool16/ADD_Attribute.gif"));
        this.addAttributeAction.setHoverImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/ctool16/ADD_Attribute.gif"));
        this.addAttributeAction.setDisabledImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/dtool16/ADD_Attribute.gif"));
        this.addAttributeListAction.setImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/etool16/ADD_Attribute.gif"));
        this.addAttributeListAction.setHoverImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/ctool16/ADD_Attribute.gif"));
        this.addAttributeListAction.setDisabledImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/dtool16/ADD_Attribute.gif"));
        this.addGroupToContentModelAction.setImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/etool16/ADD_GroupToConModel.gif"));
        this.addGroupToContentModelAction.setHoverImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/ctool16/ADD_GroupToConModel.gif"));
        this.addGroupToContentModelAction.setDisabledImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/dtool16/ADD_GroupToConModel.gif"));
        this.addElementToContentModelAction.setImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/etool16/ADD_ElementToConModel.gif"));
        this.addElementToContentModelAction.setHoverImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/ctool16/ADD_ElementToConModel.gif"));
        this.addElementToContentModelAction.setDisabledImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/dtool16/ADD_ElementToConModel.gif"));
        this.replaceEmptyContentModelWithGroupAction.setImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/etool16/ADD_GroupToConModel.gif"));
        this.replaceEmptyContentModelWithGroupAction.setHoverImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/ctool16/ADD_GroupToConModel.gif"));
        this.replaceEmptyContentModelWithGroupAction.setDisabledImageDescriptor(DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/dtool16/ADD_GroupToConModel.gif"));
    }

    void _selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        this.fViewerSelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
    }

    void addActionItemsForSelection(Object selectedObject, IMenuManager menu) {
        if (selectedObject instanceof NodeList) {
            NodeList folder = (NodeList)selectedObject;
            if (folder.getListType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.NOTATION_TAG")) {
                menu.add((IAction)this.addNotationAction);
            } else if (folder.getListType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ENTITY_TAG")) {
                menu.add((IAction)this.addEntityAction);
            } else if (folder.getListType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ELEMENT_TAG")) {
                LabelValuePair[] availableEntities = this.fModel.createParmEntityContentItems(null);
                this.addParameterEntityReferenceAction.setEnabled(availableEntities.length > 0);
                menu.add((IAction)this.addElementAction);
                menu.add((IAction)this.addParameterEntityReferenceAction);
            } else if (folder.getListType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ATTLIST_TAG")) {
                menu.add((IAction)this.addAttributeAction);
            }
        }
        if (selectedObject instanceof DTDFile || selectedObject == null) {
            LabelValuePair[] availableEntities = this.fModel.createParmEntityContentItems(null);
            this.addParameterEntityReferenceAction.setEnabled(availableEntities.length > 0);
            menu.add((IAction)this.addElementAction);
            menu.add((IAction)this.addEntityAction);
            menu.add((IAction)this.addNotationAction);
            menu.add((IAction)this.addParameterEntityReferenceAction);
            menu.add((IAction)this.addCommentAction);
            menu.add((IAction)this.addAttributeListAction);
            menu.add((IContributionItem)new Separator());
        }
        if (selectedObject instanceof Element) {
            Element dtdElement = (Element)selectedObject;
            CMNode contentModel = dtdElement.getContentModel();
            if (contentModel == null) {
                menu.add((IAction)this.addGroupToContentModelAction);
                menu.add((IAction)this.addElementToContentModelAction);
            } else if (contentModel != null && CMNode.EMPTY.equals(contentModel.getType())) {
                menu.add((IAction)this.replaceEmptyContentModelWithGroupAction);
            }
            menu.add((IAction)this.addAttributeAction);
        } else if (selectedObject instanceof CMGroupNode) {
            menu.add((IAction)this.addElementToContentModelAction);
            menu.add((IAction)this.addGroupToContentModelAction);
        } else if (selectedObject instanceof AttributeList) {
            menu.add((IAction)this.addAttributeAction);
        }
        menu.add((IContributionItem)new Separator());
        this.addEditActions(menu);
        menu.add((IContributionItem)new Separator());
        if (!(!(selectedObject instanceof DTDNode) || selectedObject instanceof CMNode && ((CMNode)selectedObject).isRootElementContent())) {
            menu.add((IAction)this.deleteAction);
            this.deleteAction.setEnabled(true);
        }
    }

    void addEditActions(IMenuManager menu) {
    }

    public void createMenuListenersFor(Viewer viewer) {
        viewer.addSelectionChangedListener(this.fInternalSelectionChangedListener);
        ISelection selection = viewer.getSelection();
        this.fViewerSelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
        this.fViewerList.add(viewer);
    }

    public IMenuListener getMenuListener() {
        return this.fMenuListener;
    }

    public void removeMenuListenersFor(Viewer viewer) {
        viewer.removeSelectionChangedListener(this.fInternalSelectionChangedListener);
        this.fViewerList.remove(viewer);
    }

    class DTDMenuListener
    implements IMenuListener {
        DTDMenuListener() {
        }

        public void menuAboutToShow(IMenuManager manager) {
            DTDContextMenuHelper.this.addNotationAction.selectionChanged(DTDContextMenuHelper.this.fViewerSelection);
            DTDContextMenuHelper.this.addEntityAction.selectionChanged(DTDContextMenuHelper.this.fViewerSelection);
            DTDContextMenuHelper.this.addElementAction.selectionChanged(DTDContextMenuHelper.this.fViewerSelection);
            DTDContextMenuHelper.this.addCommentAction.selectionChanged(DTDContextMenuHelper.this.fViewerSelection);
            DTDContextMenuHelper.this.addParameterEntityReferenceAction.selectionChanged(DTDContextMenuHelper.this.fViewerSelection);
            DTDContextMenuHelper.this.deleteAction.selectionChanged(DTDContextMenuHelper.this.fViewerSelection);
            DTDContextMenuHelper.this.addAttributeAction.selectionChanged(DTDContextMenuHelper.this.fViewerSelection);
            DTDContextMenuHelper.this.addAttributeListAction.selectionChanged(DTDContextMenuHelper.this.fViewerSelection);
            DTDContextMenuHelper.this.addGroupToContentModelAction.selectionChanged(DTDContextMenuHelper.this.fViewerSelection);
            DTDContextMenuHelper.this.addElementToContentModelAction.selectionChanged(DTDContextMenuHelper.this.fViewerSelection);
            DTDContextMenuHelper.this.replaceEmptyContentModelWithGroupAction.selectionChanged(DTDContextMenuHelper.this.fViewerSelection);
            if (!DTDContextMenuHelper.this.fViewerSelection.isEmpty()) {
                DTDContextMenuHelper.this.addActionItemsForSelection(DTDContextMenuHelper.this.fViewerSelection.getFirstElement(), manager);
            }
        }
    }

    class ViewerSelectionChangeListener
    implements ISelectionChangedListener {
        ViewerSelectionChangeListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            DTDContextMenuHelper.this._selectionChanged(event);
        }
    }
}

