/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.correction;

import java.util.Map;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.wst.sse.ui.internal.correction.AnnotationQueryResult;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;

class AnnotationQuery {
    private String type;
    private String[] attributes;
    private int hashCode;

    public AnnotationQuery(String annotationType, String[] annotationAttributes) {
        if (annotationAttributes == null) {
            throw new IllegalArgumentException();
        }
        this.type = annotationType;
        this.attributes = annotationAttributes;
        this.computeHashCode();
    }

    public AnnotationQueryResult performQuery(Annotation anno) {
        String problemType;
        if (!(anno instanceof TemporaryAnnotation)) {
            return null;
        }
        Map annoAttributes = ((TemporaryAnnotation)anno).getAttributes();
        if (this.type != null && !this.type.equals(problemType = (String)annoAttributes.get("problemType"))) {
            return null;
        }
        String[] values = new String[this.attributes.length];
        int i = 0;
        while (i < this.attributes.length) {
            Object value = annoAttributes.get(this.attributes[i]);
            if (value == null) {
                return null;
            }
            values[i] = value.toString();
            ++i;
        }
        return new AnnotationQueryResult(values);
    }

    public boolean equals(Object o) {
        if (!(o instanceof AnnotationQuery)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        AnnotationQuery mq = (AnnotationQuery)o;
        if (this.type == null ? mq.type != null : !this.type.equals(mq.type)) {
            return false;
        }
        if (this.attributes.length != mq.attributes.length) {
            return false;
        }
        int i = 0;
        while (i < this.attributes.length) {
            if (!this.attributes[i].equals(mq.attributes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void computeHashCode() {
        this.hashCode = 19;
        if (this.type != null) {
            this.hashCode = this.hashCode * 37 + this.type.hashCode();
        }
        int i = 0;
        while (i < this.attributes.length) {
            this.hashCode = this.hashCode * 37 + this.attributes[i].hashCode();
            ++i;
        }
    }

    public String getType() {
        return this.type;
    }

    public String[] getAttributes() {
        return this.attributes;
    }
}

