/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.preferences.ui;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wst.sse.ui.internal.Logger;

public class ColorHelper {
    public static final String BACKGROUND = "background";
    public static final String BOLD = "bold";
    public static final String FOREGROUND = "foreground";
    public static final String NAME = "name";
    private static final String STYLE_SEPARATOR = "|";
    private static final String NULL = "null";

    public static String getColorString(int r, int g, int b) {
        return "#" + ColorHelper.getHexString(r, 2) + ColorHelper.getHexString(g, 2) + ColorHelper.getHexString(b, 2);
    }

    private static String getHexString(int value, int minWidth) {
        String hexString = Integer.toHexString(value);
        int i = hexString.length();
        while (i < minWidth) {
            hexString = "0" + hexString;
            ++i;
        }
        return hexString;
    }

    public static String packStylePreferences(String[] stylePrefs) {
        StringBuffer styleString = new StringBuffer();
        int i = 0;
        while (i < stylePrefs.length) {
            String s = stylePrefs[i];
            if (i < 2) {
                if (s != null) {
                    styleString.append(s);
                } else {
                    styleString.append(NULL);
                }
            } else {
                styleString.append(Boolean.valueOf(s));
            }
            if (i < stylePrefs.length - 1) {
                styleString.append(" | ");
            }
            ++i;
        }
        return styleString.toString();
    }

    public static RGB toRGB(String anRGBString) {
        RGB result = null;
        if (anRGBString.length() > 6 && anRGBString.charAt(0) == '#') {
            int r = 0;
            int g = 0;
            int b = 0;
            try {
                r = Integer.valueOf(anRGBString.substring(1, 3), 16);
                g = Integer.valueOf(anRGBString.substring(3, 5), 16);
                b = Integer.valueOf(anRGBString.substring(5, 7), 16);
                result = new RGB(r, g, b);
            }
            catch (NumberFormatException nfExc) {
                Logger.logException("Could not load highlighting preference for color " + anRGBString, nfExc);
            }
        }
        return result;
    }

    public static String toRGBString(RGB anRGB) {
        if (anRGB == null) {
            return "#000000";
        }
        String red = Integer.toHexString(anRGB.red);
        while (red.length() < 2) {
            red = "0" + red;
        }
        String green = Integer.toHexString(anRGB.green);
        while (green.length() < 2) {
            green = "0" + green;
        }
        String blue = Integer.toHexString(anRGB.blue);
        while (blue.length() < 2) {
            blue = "0" + blue;
        }
        return "#" + red + green + blue;
    }

    public static String[] unpackStylePreferences(String preference) {
        String[] stylePrefs = new String[6];
        if (preference != null) {
            String background;
            String foreground;
            StringTokenizer st = new StringTokenizer(preference, STYLE_SEPARATOR);
            stylePrefs[0] = st.hasMoreTokens() ? (foreground = st.nextToken().trim()) : NULL;
            stylePrefs[1] = st.hasMoreTokens() ? (background = st.nextToken().trim()) : NULL;
            if (st.hasMoreTokens()) {
                String bold = st.nextToken().trim();
                stylePrefs[2] = Boolean.valueOf(bold).toString();
            } else {
                stylePrefs[2] = Boolean.FALSE.toString();
            }
            if (st.hasMoreTokens()) {
                String italic = st.nextToken().trim();
                stylePrefs[3] = Boolean.valueOf(italic).toString();
            } else {
                stylePrefs[3] = Boolean.FALSE.toString();
            }
            if (st.hasMoreTokens()) {
                String strikethrough = st.nextToken().trim();
                stylePrefs[4] = Boolean.valueOf(strikethrough).toString();
            } else {
                stylePrefs[4] = Boolean.FALSE.toString();
            }
            if (st.hasMoreTokens()) {
                String underline = st.nextToken().trim();
                stylePrefs[5] = Boolean.valueOf(underline).toString();
            } else {
                stylePrefs[5] = Boolean.FALSE.toString();
            }
        }
        return stylePrefs;
    }
}

