/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.design;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.sf.antcontrib.design.Depends;
import net.sf.antcontrib.design.Log;
import net.sf.antcontrib.design.Package;
import net.sf.antcontrib.design.VerifyDesignDelegate;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;

public class Design {
    private Map nameToPackage = new HashMap();
    private Map packageNameToPackage = new HashMap();
    private boolean isCircularDesign;
    private Log log;
    private Location location;
    private String currentClass = null;
    private String currentPackageName = null;
    private Package currentAliasPackage = null;
    private HashSet primitives = new HashSet();
    static /* synthetic */ Class class$net$sf$antcontrib$design$VerifyDesign;

    public Design(boolean isCircularDesign, Log log, Location loc) {
        Package p = new Package();
        p.setIncludeSubpackages(true);
        p.setName("java");
        p.setNeedDeclarations(false);
        p.setPackage("java");
        this.addConfiguredPackage(p);
        this.isCircularDesign = isCircularDesign;
        this.log = log;
        this.location = loc;
        this.primitives.add("boolean");
        this.primitives.add("byte");
        this.primitives.add("short");
        this.primitives.add("int");
        this.primitives.add("long");
        this.primitives.add("char");
        this.primitives.add("double");
        this.primitives.add("float");
    }

    private Package getPackage(String nameAttribute) {
        return (Package)this.nameToPackage.get(nameAttribute);
    }

    private Package retreivePack(String thePackage) {
        if (thePackage == null) {
            throw new IllegalArgumentException("Cannot retrieve null packages");
        }
        Package result = null;
        String currentPackage = thePackage;
        while (!"<default package>".equals(currentPackage)) {
            result = (Package)this.packageNameToPackage.get(currentPackage);
            if (result != null) {
                if (currentPackage.equals(thePackage)) {
                    return result;
                }
                if (result.isIncludeSubpackages()) {
                    return result;
                }
                return null;
            }
            currentPackage = VerifyDesignDelegate.getPackageName(currentPackage);
        }
        if (result != null && result.isIncludeSubpackages()) {
            return result;
        }
        return null;
    }

    public void addConfiguredPackage(Package p) {
        String pack = p.getPackage();
        Depends[] depends = p.getDepends();
        if (depends != null && !this.isCircularDesign) {
            for (int i = 0; i < depends.length; ++i) {
                Package dependsPackage = (Package)this.nameToPackage.get(depends[i].getName());
                if (dependsPackage != null) continue;
                throw new RuntimeException("package name=" + p.getName() + " did not\n" + "have " + depends[i] + " listed before it.  circularDesign is off\n" + "so package=" + p.getName() + " must be moved up in the xml file");
            }
        }
        this.nameToPackage.put(p.getName(), p);
        this.packageNameToPackage.put(p.getPackage(), p);
    }

    public void verifyDependencyOk(String className) {
        this.log.log("         className=" + className, 4);
        if (className.startsWith("L")) {
            className = className.substring(1, className.length());
        }
        String classPackage = VerifyDesignDelegate.getPackageName(className);
        this.log.log("         classPackage=" + classPackage, 4);
        Package p = this.retreivePack(classPackage);
        if (p != null && !p.isNeedDeclarations()) {
            return;
        }
        String pack = this.currentAliasPackage.getPackage();
        this.log.log("         pack=" + pack, 4);
        this.log.log("         classPack=" + classPackage, 4);
        if (this.isClassInPackage(className, this.currentAliasPackage)) {
            return;
        }
        Depends[] depends = this.currentAliasPackage.getDepends();
        for (int i = 0; i < depends.length; ++i) {
            Depends d = depends[i];
            String name = d.getName();
            Package temp = this.getPackage(name);
            if (!this.isClassInPackage(className, temp)) continue;
            return;
        }
        throw new BuildException(Design.getErrorMessage(this.currentClass, className), this.location);
    }

    public boolean isClassInPackage(String className, Package p) {
        String classPackage = VerifyDesignDelegate.getPackageName(className);
        return p.isIncludeSubpackages() ? className.startsWith(p.getPackage()) : classPackage.equals(p.getPackage());
    }

    public void setCurrentClass(String className) {
        this.currentClass = className;
        String packageName = VerifyDesignDelegate.getPackageName(className);
        if (!packageName.equals(this.currentPackageName)) {
            this.currentPackageName = packageName;
            this.log.log("Evaluating package=" + this.currentPackageName, 2);
            this.currentAliasPackage = this.retreivePack(packageName);
            if (this.currentAliasPackage == null) {
                throw new BuildException("\nPackage=" + packageName + " is not defined in the design.\n" + "All packages with classes must be declared in the design file\n" + "Class found in the offending package=" + className, this.location);
            }
        }
        this.log.log("   class=" + className, 3);
        if (!className.startsWith(this.currentPackageName)) {
            throw new RuntimeException("Internal Error");
        }
    }

    public String getCurrentClass() {
        return this.currentClass;
    }

    void checkClass(String dependsOn) {
        this.log.log("         dependsOn1=" + dependsOn, 4);
        if (dependsOn.endsWith("[]")) {
            int index = dependsOn.indexOf("[");
            dependsOn = dependsOn.substring(0, index);
            this.log.log("         dependsOn2=" + dependsOn, 4);
        }
        if (this.primitives.contains(dependsOn)) {
            return;
        }
        String tempTry = "java.lang." + dependsOn;
        try {
            Class<?> c = (class$net$sf$antcontrib$design$VerifyDesign == null ? (class$net$sf$antcontrib$design$VerifyDesign = Design.class$("net.sf.antcontrib.design.VerifyDesign")) : class$net$sf$antcontrib$design$VerifyDesign).getClassLoader().loadClass(tempTry);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.verifyDependencyOk(dependsOn);
            return;
        }
    }

    public static String getErrorMessage(String className, String dependsOnClass) {
        String s = "Package=" + VerifyDesignDelegate.getPackageName(className) + " is not defined to" + "\ndepend on package=" + VerifyDesignDelegate.getPackageName(dependsOnClass) + "\n" + className + " depends on " + dependsOnClass + " which" + "\nviolates the specified design.  Change your code or the design";
        return s;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

