/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.BaseResourceCollectionContainer;
import org.apache.tools.ant.types.resources.FailFast;
import org.apache.tools.ant.types.resources.FileResource;

public abstract class BaseResourceCollectionWrapper
extends DataType
implements ResourceCollection,
Cloneable {
    private static final String ONE_NESTED_MESSAGE = " expects exactly one nested resource collection.";
    private ResourceCollection rc;
    private Collection coll = null;
    private boolean cache = true;

    public synchronized void setCache(boolean b) {
        this.cache = b;
    }

    public synchronized boolean isCache() {
        return this.cache;
    }

    public synchronized void add(ResourceCollection c) throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (c == null) {
            return;
        }
        if (this.rc != null) {
            throw this.oneNested();
        }
        this.rc = c;
        this.setChecked(false);
    }

    public final synchronized Iterator iterator() {
        if (this.isReference()) {
            return ((BaseResourceCollectionWrapper)this.getCheckedRef()).iterator();
        }
        this.dieOnCircularReference();
        return new FailFast(this, this.cacheCollection().iterator());
    }

    public synchronized int size() {
        if (this.isReference()) {
            return ((BaseResourceCollectionWrapper)this.getCheckedRef()).size();
        }
        this.dieOnCircularReference();
        return this.cacheCollection().size();
    }

    public synchronized boolean isFilesystemOnly() {
        if (this.isReference()) {
            return ((BaseResourceCollectionContainer)this.getCheckedRef()).isFilesystemOnly();
        }
        this.dieOnCircularReference();
        if (this.rc == null || this.rc.isFilesystemOnly()) {
            return true;
        }
        Iterator i = this.cacheCollection().iterator();
        while (i.hasNext()) {
            if (i.next() instanceof FileResource) continue;
            return false;
        }
        return true;
    }

    protected synchronized void dieOnCircularReference(Stack stk, Project p) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        if (this.isReference()) {
            super.dieOnCircularReference(stk, p);
        } else {
            if (this.rc instanceof DataType) {
                stk.push(this.rc);
                BaseResourceCollectionWrapper.invokeCircularReferenceCheck((DataType)((Object)this.rc), stk, p);
                stk.pop();
            }
            this.setChecked(true);
        }
    }

    protected final synchronized ResourceCollection getResourceCollection() {
        this.dieOnCircularReference();
        if (this.rc == null) {
            throw this.oneNested();
        }
        return this.rc;
    }

    protected abstract Collection getCollection();

    public synchronized String toString() {
        if (this.isReference()) {
            return this.getCheckedRef().toString();
        }
        if (this.cacheCollection().size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator i = this.coll.iterator();
        while (i.hasNext()) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(i.next());
        }
        return sb.toString();
    }

    private synchronized Collection cacheCollection() {
        if (this.coll == null || !this.isCache()) {
            this.coll = this.getCollection();
        }
        return this.coll;
    }

    private BuildException oneNested() {
        return new BuildException(super.toString() + ONE_NESTED_MESSAGE);
    }
}

