/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.xml;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.opensaml.xml.parse.ClasspathResolver;
import org.opensaml.xml.parse.LoggingErrorHandler;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SAMLSchemaBuilder {
    private static SoftReference<Schema> saml10Schema;
    private static SoftReference<Schema> saml11Schema;
    private static String[] baseXMLSchemas;
    private static String[] soapSchemas;
    private static String[] saml10Schemas;
    private static String[] saml11Schemas;
    private static String[] saml20Schemas;
    private static String[] baseExtSchemas;
    private static List<String> extensionSchema;

    static {
        baseXMLSchemas = new String[]{"/schema/xml.xsd", "/schema/XMLSchema.xsd", "/schema/xmldsig-core-schema.xsd", "/schema/xenc-schema.xsd"};
        soapSchemas = new String[]{"/schema/soap-envelope.xsd"};
        saml10Schemas = new String[]{"/schema/cs-sstc-schema-assertion-01.xsd", "/schema/cs-sstc-schema-protocol-01.xsd"};
        saml11Schemas = new String[]{"/schema/cs-sstc-schema-assertion-1.1.xsd", "/schema/cs-sstc-schema-protocol-1.1.xsd"};
        saml20Schemas = new String[]{"/schema/saml-schema-xacml-2.0.xsd", "/schema/saml-schema-x500-2.0.xsd", "/schema/saml-schema-protocol-2.0.xsd", "/schema/saml-schema-metadata-2.0.xsd", "/schema/saml-schema-ecp-2.0.xsd", "/schema/saml-schema-dce-2.0.xsd", "/schema/saml-schema-authn-context-xmldsig-2.0.xsd", "/schema/saml-schema-authn-context-x509-2.0.xsd", "/schema/saml-schema-authn-context-types-2.0.xsd", "/schema/saml-schema-authn-context-timesync-2.0.xsd", "/schema/saml-schema-authn-context-telephony-2.0.xsd", "/schema/saml-schema-authn-context-sslcert-2.0.xsd", "/schema/saml-schema-authn-context-srp-2.0.xsd", "/schema/saml-schema-authn-context-spki-2.0.xsd", "/schema/saml-schema-authn-context-softwarepki-2.0.xsd", "/schema/saml-schema-authn-context-smartcardpki-2.0.xsd", "/schema/saml-schema-authn-context-smartcard-2.0.xsd", "/schema/saml-schema-authn-context-session-2.0.xsd", "/schema/saml-schema-authn-context-pword-2.0.xsd", "/schema/saml-schema-authn-context-ppt-2.0.xsd", "/schema/saml-schema-authn-context-pgp-2.0.xsd", "/schema/saml-schema-authn-context-personal-telephony-2.0.xsd", "/schema/saml-schema-authn-context-nomad-telephony-2.0.xsd", "/schema/saml-schema-authn-context-mobiletwofactor-unreg-2.0.xsd", "/schema/saml-schema-authn-context-mobiletwofactor-reg-2.0.xsd", "/schema/saml-schema-authn-context-mobileonefactor-unreg-2.0.xsd", "/schema/saml-schema-authn-context-mobileonefactor-reg-2.0.xsd", "/schema/saml-schema-authn-context-kerberos-2.0.xsd", "/schema/saml-schema-authn-context-ippword-2.0.xsd", "/schema/saml-schema-authn-context-ip-2.0.xsd", "/schema/saml-schema-authn-context-auth-telephony-2.0.xsd", "/schema/saml-schema-authn-context-2.0.xsd", "/schema/saml-schema-assertion-2.0.xsd"};
        baseExtSchemas = new String[]{"/schema/sstc-saml-protocol-ext-thirdparty.xsd", "/schema/sstc-saml-metadata-ext-query.xsd", "/schema/sstc-saml1x-metadata.xsd"};
        extensionSchema = new ArrayList<String>();
    }

    private SAMLSchemaBuilder() {
    }

    public static synchronized Schema getSAML10Schema() throws SAXException {
        if (saml10Schema == null || saml10Schema.get() == null) {
            saml10Schema = new SoftReference<Schema>(SAMLSchemaBuilder.buildSchema(saml10Schemas));
        }
        return saml10Schema.get();
    }

    public static synchronized Schema getSAML11Schema() throws SAXException {
        if (saml11Schema == null || saml11Schema.get() == null) {
            saml11Schema = new SoftReference<Schema>(SAMLSchemaBuilder.buildSchema(saml11Schemas));
        }
        return saml11Schema.get();
    }

    public static List<String> getExtensionSchema() {
        return Collections.unmodifiableList(extensionSchema);
    }

    public static void addExtensionSchema(String schema) {
        extensionSchema.add(schema);
        saml10Schema = null;
        saml11Schema = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSchema(String schema) {
        extensionSchema.remove(schema);
        SoftReference<Schema> softReference = saml10Schema;
        synchronized (softReference) {
            saml10Schema = null;
        }
        softReference = saml11Schema;
        synchronized (softReference) {
            saml11Schema = null;
        }
    }

    private static Schema buildSchema(String[] saml1Schema) throws SAXException {
        String source2;
        Class<SAMLSchemaBuilder> clazz = SAMLSchemaBuilder.class;
        ArrayList<StreamSource> schemaSources = new ArrayList<StreamSource>();
        String[] stringArray = baseXMLSchemas;
        int n = baseXMLSchemas.length;
        int n2 = 0;
        while (n2 < n) {
            source2 = stringArray[n2];
            schemaSources.add(new StreamSource(clazz.getResourceAsStream(source2)));
            ++n2;
        }
        stringArray = soapSchemas;
        n = soapSchemas.length;
        n2 = 0;
        while (n2 < n) {
            source2 = stringArray[n2];
            schemaSources.add(new StreamSource(clazz.getResourceAsStream(source2)));
            ++n2;
        }
        stringArray = saml1Schema;
        n = saml1Schema.length;
        n2 = 0;
        while (n2 < n) {
            source2 = stringArray[n2];
            schemaSources.add(new StreamSource(clazz.getResourceAsStream(source2)));
            ++n2;
        }
        stringArray = saml20Schemas;
        n = saml20Schemas.length;
        n2 = 0;
        while (n2 < n) {
            source2 = stringArray[n2];
            schemaSources.add(new StreamSource(clazz.getResourceAsStream(source2)));
            ++n2;
        }
        stringArray = baseExtSchemas;
        n = baseExtSchemas.length;
        n2 = 0;
        while (n2 < n) {
            source2 = stringArray[n2];
            schemaSources.add(new StreamSource(clazz.getResourceAsStream(source2)));
            ++n2;
        }
        for (String source2 : extensionSchema) {
            schemaSources.add(new StreamSource(clazz.getResourceAsStream(source2)));
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setResourceResolver((LSResourceResolver)new ClasspathResolver());
        schemaFactory.setErrorHandler((ErrorHandler)new LoggingErrorHandler(LoggerFactory.getLogger(clazz)));
        return schemaFactory.newSchema(schemaSources.toArray(new StreamSource[0]));
    }
}

