/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.core.validator;

import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.OneTimeUse;
import org.opensaml.saml2.core.ProxyRestriction;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionsSpecValidator
implements Validator<Conditions> {
    public void validate(Conditions conditions) throws ValidationException {
        this.validateOneTimeUseCondition(conditions);
        this.validateProxyRestrictionCondition(conditions);
    }

    protected void validateOneTimeUseCondition(Conditions conditions) throws ValidationException {
        int oneTimeUseCount = 0;
        int i = 0;
        while (i < conditions.getConditions().size()) {
            if (conditions.getConditions().get(i) instanceof OneTimeUse) {
                ++oneTimeUseCount;
            }
            ++i;
        }
        if (oneTimeUseCount > 1) {
            throw new ValidationException("At most one instance of OneTimeUse allowed");
        }
    }

    protected void validateProxyRestrictionCondition(Conditions conditions) throws ValidationException {
        int proxyRestrictionCount = 0;
        int i = 0;
        while (i < conditions.getConditions().size()) {
            if (conditions.getConditions().get(i) instanceof ProxyRestriction) {
                ++proxyRestrictionCount;
            }
            ++i;
        }
        if (proxyRestrictionCount > 1) {
            throw new ValidationException("At most one instance of ProxyRestriction allowed");
        }
    }
}

