/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.provider;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.opensaml.saml2.common.SAML2Helper;
import org.opensaml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.provider.BaseMetadataProvider;
import org.opensaml.saml2.metadata.provider.FilterException;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMetadataProvider
extends BaseMetadataProvider {
    private final Logger log = LoggerFactory.getLogger(AbstractMetadataProvider.class);
    private HashMap<String, EntityDescriptor> indexedDescriptors = new HashMap();
    private ParserPool parser;

    @Override
    public EntitiesDescriptor getEntitiesDescriptor(String name) throws MetadataProviderException {
        XMLObject metadata = this.getMetadata();
        if (metadata instanceof EntitiesDescriptor) {
            EntitiesDescriptor descriptor = (EntitiesDescriptor)metadata;
            return this.getEntitiesDescriptorByName(name, descriptor);
        }
        this.log.debug("Metadata document does not contain an EntitiesDescriptor with the ID {}", (Object)name);
        return null;
    }

    @Override
    public EntityDescriptor getEntityDescriptor(String entityID) throws MetadataProviderException {
        XMLObject metadata = this.getMetadata();
        EntityDescriptor descriptor = this.getEntityDescriptorById(entityID, metadata);
        if (descriptor == null) {
            this.log.debug("Metadata document does not contain an EntityDescriptor with the ID {}", (Object)entityID);
            return null;
        }
        return descriptor;
    }

    @Override
    public List<RoleDescriptor> getRole(String entityID, QName roleName) throws MetadataProviderException {
        EntityDescriptor entity = this.getEntityDescriptor(entityID);
        if (entity != null) {
            return entity.getRoleDescriptors(roleName);
        }
        return null;
    }

    @Override
    public RoleDescriptor getRole(String entityID, QName roleName, String supportedProtocol) throws MetadataProviderException {
        List<RoleDescriptor> roles = this.getRole(entityID, roleName);
        if (roles == null) {
            return null;
        }
        for (RoleDescriptor role : roles) {
            if (!role.isSupportedProtocol(supportedProtocol)) continue;
            return role;
        }
        return null;
    }

    public ParserPool getParserPool() {
        return this.parser;
    }

    public void setParserPool(ParserPool pool) {
        this.parser = pool;
    }

    protected void clearDescriptorIndex() {
        this.indexedDescriptors.clear();
    }

    protected XMLObject unmarshallMetadata(InputStream metadataInput) throws UnmarshallingException {
        try {
            XMLObject metadata;
            this.log.trace("Parsing retrieved metadata into a DOM object");
            Document mdDocument = this.parser.parse(metadataInput);
            this.log.trace("Unmarshalling and caching metdata DOM");
            Unmarshaller unmarshaller = this.unmarshallerFactory.getUnmarshaller(mdDocument.getDocumentElement());
            XMLObject xMLObject = metadata = unmarshaller.unmarshall(mdDocument.getDocumentElement());
            return xMLObject;
        }
        catch (Exception e) {
            throw new UnmarshallingException(e);
        }
        finally {
            try {
                metadataInput.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void filterMetadata(XMLObject metadata) throws FilterException {
        if (this.getMetadataFilter() != null) {
            this.log.debug("Applying metadata filter");
            this.getMetadataFilter().doFilter(metadata);
        }
    }

    protected void releaseMetadataDOM(XMLObject metadata) {
        if (metadata != null) {
            metadata.releaseDOM();
            metadata.releaseChildrenDOM(true);
        }
    }

    protected EntityDescriptor getEntityDescriptorById(String entityID, XMLObject metadata) {
        EntityDescriptor descriptor = null;
        this.log.debug("Searching for entity descriptor with an entity ID of {}", (Object)entityID);
        if (this.indexedDescriptors.containsKey(entityID)) {
            descriptor = this.indexedDescriptors.get(entityID);
            if (this.isValid((XMLObject)descriptor)) {
                this.log.trace("Entity descriptor for the ID {} was found in index cache, returning", (Object)entityID);
                return descriptor;
            }
            this.indexedDescriptors.remove(descriptor);
        }
        if (metadata != null) {
            if (metadata instanceof EntityDescriptor) {
                this.log.trace("Metadata root is an entity descriptor, checking if it's the one we're looking for.");
                descriptor = (EntityDescriptor)metadata;
                if (!descriptor.getEntityID().equals(entityID)) {
                    descriptor = null;
                }
                if (!this.isValid((XMLObject)descriptor)) {
                    this.log.trace("Found entity descriptor for entity with ID {} but it is no longer valid, skipping it.", (Object)entityID);
                    descriptor = null;
                }
            } else {
                this.log.trace("Metadata was an EntitiesDescriptor, checking if any of its descendant EntityDescriptor elements is the one we're looking for.");
                if (metadata instanceof EntitiesDescriptor) {
                    descriptor = this.getEntityDescriptorById(entityID, (EntitiesDescriptor)metadata);
                }
            }
        }
        if (descriptor != null) {
            this.log.trace("Located entity descriptor, creating an index to it for faster lookups");
            this.indexedDescriptors.put(entityID, descriptor);
        }
        return descriptor;
    }

    protected EntityDescriptor getEntityDescriptorById(String entityID, EntitiesDescriptor descriptor) {
        this.log.trace("Checking to see if any of the child entity descriptors of entities descriptor {} is the requested descriptor", (Object)descriptor.getName());
        List<EntityDescriptor> entityDescriptors = descriptor.getEntityDescriptors();
        if (entityDescriptors != null) {
            for (EntityDescriptor entityDescriptor : entityDescriptors) {
                this.log.trace("Checking entity descriptor with entity ID {}", (Object)entityDescriptor.getEntityID());
                if (!entityDescriptor.getEntityID().equals(entityID) || !this.isValid((XMLObject)entityDescriptor)) continue;
                return entityDescriptor;
            }
        }
        this.log.trace("Checking to see if any of the child entities descriptors contains the entity descriptor requested");
        List<EntitiesDescriptor> entitiesDescriptors = descriptor.getEntitiesDescriptors();
        if (entitiesDescriptors != null) {
            for (EntitiesDescriptor entitiesDescriptor : descriptor.getEntitiesDescriptors()) {
                EntityDescriptor entityDescriptor;
                entityDescriptor = this.getEntityDescriptorById(entityID, entitiesDescriptor);
                if (entityDescriptor == null) continue;
                return entityDescriptor;
            }
        }
        return null;
    }

    protected EntitiesDescriptor getEntitiesDescriptorByName(String name, EntitiesDescriptor rootDescriptor) {
        EntitiesDescriptor descriptor = null;
        if (DatatypeHelper.safeEquals((Object)name, (Object)rootDescriptor.getName()) && this.isValid((XMLObject)rootDescriptor)) {
            descriptor = rootDescriptor;
        } else {
            List<EntitiesDescriptor> childDescriptors = rootDescriptor.getEntitiesDescriptors();
            if (childDescriptors != null) {
                for (EntitiesDescriptor childDescriptor : childDescriptors) {
                    if ((childDescriptor = this.getEntitiesDescriptorByName(name, childDescriptor)) == null) continue;
                    descriptor = childDescriptor;
                }
            }
        }
        return descriptor;
    }

    protected boolean isValid(XMLObject descriptor) {
        if (!this.requireValidMetadata()) {
            return true;
        }
        return SAML2Helper.isValid(descriptor);
    }
}

