/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.validator;

import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.validator.SSODescriptorSpecValidator;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.validation.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDPSSODescriptorSpecValidator
extends SSODescriptorSpecValidator<IDPSSODescriptor> {
    @Override
    public void validate(IDPSSODescriptor idpssoDescriptor) throws ValidationException {
        super.validate(idpssoDescriptor);
        this.validateSingleSign(idpssoDescriptor);
        this.validateNameIDMapping(idpssoDescriptor);
    }

    protected void validateSingleSign(IDPSSODescriptor idpssoDescriptor) throws ValidationException {
        if (idpssoDescriptor.getSingleSignOnServices() != null && idpssoDescriptor.getSingleSignOnServices().size() > 0) {
            int i = 0;
            while (i < idpssoDescriptor.getSingleSignOnServices().size()) {
                if (!DatatypeHelper.isEmpty((String)idpssoDescriptor.getSingleSignOnServices().get(i).getResponseLocation())) {
                    throw new ValidationException("ResponseLocation of all SingleSignOnServices must be null");
                }
                ++i;
            }
        }
    }

    protected void validateNameIDMapping(IDPSSODescriptor idpssoDescriptor) throws ValidationException {
        if (idpssoDescriptor.getNameIDMappingServices() != null && idpssoDescriptor.getNameIDMappingServices().size() > 0) {
            int i = 0;
            while (i < idpssoDescriptor.getNameIDMappingServices().size()) {
                if (!DatatypeHelper.isEmpty((String)idpssoDescriptor.getNameIDMappingServices().get(i).getResponseLocation())) {
                    throw new ValidationException("ResponseLocation of all NameIDMappingServices must be null");
                }
                ++i;
            }
        }
    }
}

