/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.helpers.ThrowableToStringArray;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusPrinter {
    private static PrintStream ps = System.out;
    static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss,SSS");

    public static void setPrintStream(PrintStream printStream) {
        ps = printStream;
    }

    public static void printIfErrorsOccured(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager sm = context.getStatusManager();
        if (sm == null) {
            ps.println("WARN: Context named \"" + context.getName() + "\" has no status manager");
        } else if (sm.getLevel() == 2) {
            StatusPrinter.print(sm);
        }
    }

    public static void print(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager sm = context.getStatusManager();
        if (sm == null) {
            ps.println("WARN: Context named \"" + context.getName() + "\" has no status manager");
        } else {
            StatusPrinter.print(sm);
        }
    }

    public static void print(StatusManager sm) {
        StringBuilder sb = new StringBuilder();
        StatusPrinter.buildStrFromStatusManager(sb, sm);
        ps.println(sb.toString());
    }

    public static void print(List<Status> statusList) {
        StringBuilder sb = new StringBuilder();
        StatusPrinter.buildStrFromStatusList(sb, statusList);
        ps.println(sb.toString());
    }

    private static void buildStrFromStatusList(StringBuilder sb, List<Status> statusList) {
        for (Status s : statusList) {
            StatusPrinter.buildStr(sb, "", s);
        }
    }

    private static void buildStrFromStatusManager(StringBuilder sb, StatusManager sm) {
        StatusPrinter.buildStrFromStatusList(sb, sm.getCopyOfStatusList());
    }

    private static void appendThrowable(StringBuilder sb, Throwable t) {
        String[] stringRep;
        for (String s : stringRep = ThrowableToStringArray.convert(t)) {
            if (!s.startsWith("Caused by: ")) {
                if (Character.isDigit(s.charAt(0))) {
                    sb.append("\t... ");
                } else {
                    sb.append("\tat ");
                }
            }
            sb.append(s).append(CoreConstants.LINE_SEPARATOR);
        }
    }

    public static void buildStr(StringBuilder sb, String indentation, Status s) {
        String prefix = s.hasChildren() ? indentation + "+ " : indentation + "|-";
        if (simpleDateFormat != null) {
            Date date = new Date(s.getDate());
            String dateStr = simpleDateFormat.format(date);
            sb.append(dateStr).append(" ");
        }
        sb.append(prefix).append(s).append(CoreConstants.LINE_SEPARATOR);
        if (s.getThrowable() != null) {
            StatusPrinter.appendThrowable(sb, s.getThrowable());
        }
        if (s.hasChildren()) {
            Iterator<Status> ite = s.iterator();
            while (ite.hasNext()) {
                Status child = ite.next();
                StatusPrinter.buildStr(sb, indentation + "  ", child);
            }
        }
    }
}

