/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.opensaml.xml.Namespace;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.IDIndex;
import org.opensaml.xml.util.LazySet;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXMLObject
implements XMLObject {
    private final Logger log = LoggerFactory.getLogger(AbstractXMLObject.class);
    private XMLObject parent;
    private QName elementQname;
    private String schemaLocation;
    private String noNamespaceSchemaLocation;
    private QName typeQname;
    private Set<Namespace> namespaces;
    private Element dom;
    private final IDIndex idIndex = new IDIndex(this);

    protected AbstractXMLObject(String namespaceURI, String elementLocalName, String namespacePrefix) {
        this.namespaces = new LazySet<Namespace>();
        this.elementQname = XMLHelper.constructQName(namespaceURI, elementLocalName, namespacePrefix);
        this.addNamespace(new Namespace(namespaceURI, namespacePrefix));
        this.setElementNamespacePrefix(namespacePrefix);
    }

    @Override
    public void addNamespace(Namespace namespace) {
        if (namespace != null) {
            this.namespaces.add(namespace);
        }
    }

    @Override
    public void detach() {
        this.releaseParentDOM(true);
        this.parent = null;
    }

    @Override
    public Element getDOM() {
        return this.dom;
    }

    @Override
    public QName getElementQName() {
        return new QName(this.elementQname.getNamespaceURI(), this.elementQname.getLocalPart(), this.elementQname.getPrefix());
    }

    @Override
    public IDIndex getIDIndex() {
        return this.idIndex;
    }

    @Override
    public Set<Namespace> getNamespaces() {
        return Collections.unmodifiableSet(this.namespaces);
    }

    @Override
    public String getNoNamespaceSchemaLocation() {
        return this.noNamespaceSchemaLocation;
    }

    @Override
    public XMLObject getParent() {
        return this.parent;
    }

    @Override
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    @Override
    public QName getSchemaType() {
        return this.typeQname;
    }

    @Override
    public boolean hasChildren() {
        List<XMLObject> children = this.getOrderedChildren();
        return children != null && children.size() > 0;
    }

    @Override
    public boolean hasParent() {
        return this.getParent() != null;
    }

    protected QName prepareForAssignment(QName oldValue, QName newValue) {
        if (oldValue == null) {
            if (newValue != null) {
                Namespace newNamespace = new Namespace(newValue.getNamespaceURI(), newValue.getPrefix());
                this.addNamespace(newNamespace);
                this.releaseThisandParentDOM();
                return newValue;
            }
            return null;
        }
        if (!oldValue.equals(newValue)) {
            if (newValue != null) {
                Namespace newNamespace = new Namespace(newValue.getNamespaceURI(), newValue.getPrefix());
                this.addNamespace(newNamespace);
            }
            this.releaseThisandParentDOM();
        }
        return newValue;
    }

    protected String prepareForAssignment(String oldValue, String newValue) {
        String newString = DatatypeHelper.safeTrimOrNullString(newValue);
        if (!DatatypeHelper.safeEquals(oldValue, newString)) {
            this.releaseThisandParentDOM();
        }
        return newString;
    }

    protected <T> T prepareForAssignment(T oldValue, T newValue) {
        if (oldValue == null) {
            if (newValue != null) {
                this.releaseThisandParentDOM();
                return newValue;
            }
            return null;
        }
        if (!oldValue.equals(newValue)) {
            this.releaseThisandParentDOM();
        }
        return newValue;
    }

    protected <T extends XMLObject> T prepareForAssignment(T oldValue, T newValue) {
        if (newValue != null && newValue.hasParent()) {
            throw new IllegalArgumentException(String.valueOf(newValue.getClass().getName()) + " cannot be added - it is already the child of another SAML Object");
        }
        if (oldValue == null) {
            if (newValue != null) {
                this.releaseThisandParentDOM();
                newValue.setParent(this);
                this.idIndex.registerIDMappings(newValue.getIDIndex());
                return newValue;
            }
            return null;
        }
        if (!oldValue.equals(newValue)) {
            oldValue.setParent(null);
            this.releaseThisandParentDOM();
            this.idIndex.deregisterIDMappings(oldValue.getIDIndex());
            if (newValue != null) {
                newValue.setParent(this);
                this.idIndex.registerIDMappings(newValue.getIDIndex());
            }
        }
        return newValue;
    }

    protected void registerOwnID(String oldID, String newID) {
        String newString = DatatypeHelper.safeTrimOrNullString(newID);
        if (!DatatypeHelper.safeEquals(oldID, newString)) {
            if (oldID != null) {
                this.idIndex.deregisterIDMapping(oldID);
            }
            if (newString != null) {
                this.idIndex.registerIDMapping(newString, this);
            }
        }
    }

    @Override
    public void releaseChildrenDOM(boolean propagateRelease) {
        this.log.trace("Releasing cached DOM reprsentation for children of {} with propagation set to {}", (Object)this.getElementQName(), (Object)propagateRelease);
        if (this.getOrderedChildren() != null) {
            for (XMLObject child : this.getOrderedChildren()) {
                if (child == null) continue;
                child.releaseDOM();
                if (!propagateRelease) continue;
                child.releaseChildrenDOM(propagateRelease);
            }
        }
    }

    @Override
    public void releaseDOM() {
        this.log.trace("Releasing cached DOM reprsentation for {}", (Object)this.getElementQName());
        this.setDOM(null);
    }

    @Override
    public void releaseParentDOM(boolean propagateRelease) {
        this.log.trace("Releasing cached DOM reprsentation for parent of {} with propagation set to {}", (Object)this.getElementQName(), (Object)propagateRelease);
        XMLObject parentElement = this.getParent();
        if (parentElement != null) {
            this.parent.releaseDOM();
            if (propagateRelease) {
                this.parent.releaseParentDOM(propagateRelease);
            }
        }
    }

    public void releaseThisAndChildrenDOM() {
        if (this.getDOM() != null) {
            this.releaseDOM();
            this.releaseChildrenDOM(true);
        }
    }

    public void releaseThisandParentDOM() {
        if (this.getDOM() != null) {
            this.releaseDOM();
            this.releaseParentDOM(true);
        }
    }

    @Override
    public void removeNamespace(Namespace namespace) {
        this.namespaces.remove(namespace);
    }

    @Override
    public XMLObject resolveID(String id) {
        return this.idIndex.lookup(id);
    }

    @Override
    public XMLObject resolveIDFromRoot(String id) {
        XMLObject root = this;
        while (root.hasParent()) {
            root = root.getParent();
        }
        return root.resolveID(id);
    }

    @Override
    public void setDOM(Element newDom) {
        this.dom = newDom;
    }

    public void setElementNamespacePrefix(String prefix) {
        this.elementQname = prefix == null ? new QName(this.elementQname.getNamespaceURI(), this.elementQname.getLocalPart()) : new QName(this.elementQname.getNamespaceURI(), this.elementQname.getLocalPart(), prefix);
    }

    protected void setElementQName(QName elementQName) {
        this.elementQname = XMLHelper.constructQName(elementQName.getNamespaceURI(), elementQName.getLocalPart(), elementQName.getPrefix());
        this.addNamespace(new Namespace(elementQName.getNamespaceURI(), elementQName.getLocalPart()));
    }

    @Override
    public void setNoNamespaceSchemaLocation(String location) {
        this.noNamespaceSchemaLocation = DatatypeHelper.safeTrimOrNullString(location);
    }

    @Override
    public void setParent(XMLObject newParent) {
        this.parent = newParent;
    }

    @Override
    public void setSchemaLocation(String location) {
        this.schemaLocation = DatatypeHelper.safeTrimOrNullString(location);
    }

    protected void setSchemaType(QName type) {
        if (type == null) {
            this.typeQname = null;
        } else {
            this.typeQname = type;
            this.addNamespace(new Namespace(type.getNamespaceURI(), type.getPrefix()));
        }
    }
}

