/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.encryption;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.opensaml.xml.encryption.AbstractEncryptedKeyResolver;
import org.opensaml.xml.encryption.EncryptedData;
import org.opensaml.xml.encryption.EncryptedKey;
import org.opensaml.xml.encryption.EncryptedKeyResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainingEncryptedKeyResolver
extends AbstractEncryptedKeyResolver {
    private final List<EncryptedKeyResolver> resolvers;
    private final Logger log = LoggerFactory.getLogger(ChainingEncryptedKeyResolver.class);

    public ChainingEncryptedKeyResolver() {
        this.resolvers = new ArrayList<EncryptedKeyResolver>();
    }

    public List<EncryptedKeyResolver> getResolverChain() {
        return this.resolvers;
    }

    @Override
    public Iterable<EncryptedKey> resolve(EncryptedData encryptedData) {
        if (this.resolvers.isEmpty()) {
            this.log.warn("Chaining encrypted key resolver resolution was attempted with an empty resolver chain");
            throw new IllegalStateException("The resolver chain is empty");
        }
        return new ChainingIterable(this, encryptedData);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChainingIterable
    implements Iterable<EncryptedKey> {
        private ChainingEncryptedKeyResolver parent;
        private EncryptedData encryptedData;

        public ChainingIterable(ChainingEncryptedKeyResolver resolver, EncryptedData encData) {
            this.parent = resolver;
            this.encryptedData = encData;
        }

        @Override
        public Iterator<EncryptedKey> iterator() {
            return new ChainingIterator(this.parent, this.encryptedData);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChainingIterator
    implements Iterator<EncryptedKey> {
        private final Logger log = LoggerFactory.getLogger(ChainingIterator.class);
        private ChainingEncryptedKeyResolver parent;
        private EncryptedData encryptedData;
        private Iterator<EncryptedKeyResolver> resolverIterator;
        private Iterator<EncryptedKey> keyIterator;
        private EncryptedKeyResolver currentResolver;
        private EncryptedKey nextKey;

        public ChainingIterator(ChainingEncryptedKeyResolver resolver, EncryptedData encData) {
            this.parent = resolver;
            this.encryptedData = encData;
            this.resolverIterator = this.parent.getResolverChain().iterator();
            this.keyIterator = this.getNextKeyIterator();
            this.nextKey = null;
        }

        @Override
        public boolean hasNext() {
            if (this.nextKey != null) {
                return true;
            }
            this.nextKey = this.getNextKey();
            return this.nextKey != null;
        }

        @Override
        public EncryptedKey next() {
            if (this.nextKey != null) {
                EncryptedKey tempKey = this.nextKey;
                this.nextKey = null;
                return tempKey;
            }
            EncryptedKey tempKey = this.getNextKey();
            if (tempKey != null) {
                return tempKey;
            }
            throw new NoSuchElementException("No more EncryptedKey elements are available");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove operation is not supported by this iterator");
        }

        private Iterator<EncryptedKey> getNextKeyIterator() {
            if (this.resolverIterator.hasNext()) {
                this.currentResolver = this.resolverIterator.next();
                this.log.debug("Getting key iterator from next resolver: {}", (Object)this.currentResolver.getClass().toString());
                return this.currentResolver.resolve(this.encryptedData).iterator();
            }
            this.log.debug("No more resolvers available in the resolver chain");
            this.currentResolver = null;
            return null;
        }

        /*
         * Exception decompiling
         */
        private EncryptedKey getNextKey() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

