/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.io;

import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.Namespace;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractXMLObjectMarshaller
implements Marshaller {
    private final Logger log = LoggerFactory.getLogger(AbstractXMLObjectMarshaller.class);
    private QName targetQName;
    private MarshallerFactory marshallerFactory;

    protected AbstractXMLObjectMarshaller() {
        this.marshallerFactory = Configuration.getMarshallerFactory();
    }

    protected AbstractXMLObjectMarshaller(String targetNamespaceURI, String targetLocalName) {
        this.targetQName = XMLHelper.constructQName(targetNamespaceURI, targetLocalName, null);
        this.marshallerFactory = Configuration.getMarshallerFactory();
    }

    public Element marshall(XMLObject xmlObject) throws MarshallingException {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            return this.marshall(xmlObject, document);
        }
        catch (ParserConfigurationException e) {
            throw new MarshallingException("Unable to create Document to place marshalled elements in", e);
        }
    }

    public Element marshall(XMLObject xmlObject, Document document) throws MarshallingException {
        this.log.trace("Starting to marshall {}", (Object)xmlObject.getElementQName());
        if (document == null) {
            throw new MarshallingException("Given document may not be null");
        }
        this.checkXMLObjectIsTarget(xmlObject);
        this.log.trace("Checking if {} contains a cached DOM representation", (Object)xmlObject.getElementQName());
        Element domElement = xmlObject.getDOM();
        if (domElement != null) {
            this.prepareForAdoption(xmlObject);
            if (domElement.getOwnerDocument() != document) {
                this.log.trace("Adopting DOM of XMLObject into given Document");
                XMLHelper.adoptElement(domElement, document);
            }
            this.log.trace("Setting DOM of XMLObject as document element of given Document");
            this.setDocumentElement(document, domElement);
            return domElement;
        }
        this.log.trace("{} does not contain a cached DOM representation. Creating Element to marshall into.", (Object)xmlObject.getElementQName());
        domElement = XMLHelper.constructElement(document, xmlObject.getElementQName());
        this.log.trace("Setting created element as document root");
        this.setDocumentElement(document, domElement);
        domElement = this.marshallInto(xmlObject, domElement);
        this.log.trace("Setting created element to DOM cache for XMLObject {}", (Object)xmlObject.getElementQName());
        xmlObject.setDOM(domElement);
        xmlObject.releaseParentDOM(true);
        return domElement;
    }

    public Element marshall(XMLObject xmlObject, Element parentElement) throws MarshallingException {
        this.log.trace("Starting to marshall {} as child of {}", (Object)xmlObject.getElementQName(), (Object)XMLHelper.getNodeQName(parentElement));
        if (parentElement == null) {
            throw new MarshallingException("Given parent element is null");
        }
        this.checkXMLObjectIsTarget(xmlObject);
        this.log.trace("Checking if {} contains a cached DOM representation", (Object)xmlObject.getElementQName());
        Element domElement = xmlObject.getDOM();
        if (domElement != null) {
            this.log.trace("{} contains a cached DOM representation", (Object)xmlObject.getElementQName());
            this.prepareForAdoption(xmlObject);
            this.log.trace("Appending DOM of XMLObject {} as child of parent element {}", (Object)xmlObject.getElementQName(), (Object)XMLHelper.getNodeQName(parentElement));
            XMLHelper.appendChildElement(parentElement, domElement);
            return domElement;
        }
        this.log.trace("{} does not contain a cached DOM representation. Creating Element to marshall into.", (Object)xmlObject.getElementQName());
        Document owningDocument = parentElement.getOwnerDocument();
        domElement = XMLHelper.constructElement(owningDocument, xmlObject.getElementQName());
        this.log.trace("Appending newly created element to given parent element");
        XMLHelper.appendChildElement(parentElement, domElement);
        domElement = this.marshallInto(xmlObject, domElement);
        this.log.trace("Setting created element to DOM cache for XMLObject {}", (Object)xmlObject.getElementQName());
        xmlObject.setDOM(domElement);
        xmlObject.releaseParentDOM(true);
        return domElement;
    }

    protected void setDocumentElement(Document document, Element element) {
        Element documentRoot = document.getDocumentElement();
        if (documentRoot != null) {
            document.replaceChild(element, documentRoot);
        } else {
            document.appendChild(element);
        }
    }

    protected Element marshallInto(XMLObject xmlObject, Element targetElement) throws MarshallingException {
        this.log.trace("Setting namespace prefix for {} for XMLObject {}", (Object)xmlObject.getElementQName().getPrefix(), (Object)xmlObject.getElementQName());
        this.marshallNamespacePrefix(xmlObject, targetElement);
        this.marshallSchemaInstanceAttributes(xmlObject, targetElement);
        this.marshallNamespaces(xmlObject, targetElement);
        this.marshallAttributes(xmlObject, targetElement);
        this.marshallChildElements(xmlObject, targetElement);
        this.marshallElementContent(xmlObject, targetElement);
        return targetElement;
    }

    protected void checkXMLObjectIsTarget(XMLObject xmlObject) throws MarshallingException {
        if (this.targetQName == null) {
            this.log.trace("Targeted QName checking is not available for this marshaller, XMLObject {} was not verified", (Object)xmlObject.getElementQName());
            return;
        }
        this.log.trace("Checking that {} meets target criteria", (Object)xmlObject.getElementQName());
        QName type = xmlObject.getSchemaType();
        if (type != null && type.equals(this.targetQName)) {
            this.log.trace("{} schema type matches target", (Object)xmlObject.getElementQName());
            return;
        }
        QName elementQName = xmlObject.getElementQName();
        if (elementQName.equals(this.targetQName)) {
            this.log.trace("{} element QName matches target", (Object)xmlObject.getElementQName());
            return;
        }
        String errorMsg = "This marshaller only operations on " + this.targetQName + " elements not " + xmlObject.getElementQName();
        this.log.error(errorMsg);
        throw new MarshallingException(errorMsg);
    }

    protected void marshallNamespacePrefix(XMLObject xmlObject, Element domElement) {
        String prefix = xmlObject.getElementQName().getPrefix();
        if ((prefix = DatatypeHelper.safeTrimOrNullString(prefix)) != null) {
            domElement.setPrefix(prefix);
        }
    }

    protected void marshallChildElements(XMLObject xmlObject, Element domElement) throws MarshallingException {
        this.log.trace("Marshalling child elements for XMLObject {}", (Object)xmlObject.getElementQName());
        List<XMLObject> childXMLObjects = xmlObject.getOrderedChildren();
        if (childXMLObjects != null && childXMLObjects.size() > 0) {
            for (XMLObject childXMLObject : childXMLObjects) {
                if (childXMLObject == null) continue;
                this.log.trace("Getting marshaller for child XMLObject {}", (Object)childXMLObject.getElementQName());
                Marshaller marshaller = this.marshallerFactory.getMarshaller(childXMLObject);
                if (marshaller == null) {
                    marshaller = this.marshallerFactory.getMarshaller(Configuration.getDefaultProviderQName());
                    if (marshaller == null) {
                        String errorMsg = "No marshaller available for " + childXMLObject.getElementQName() + ", child of " + xmlObject.getElementQName();
                        this.log.error(errorMsg);
                        throw new MarshallingException(errorMsg);
                    }
                    this.log.trace("No marshaller was registered for {}, child of {}. Using default marshaller", (Object)childXMLObject.getElementQName(), (Object)xmlObject.getElementQName());
                }
                this.log.trace("Marshalling {} and adding it to DOM", (Object)childXMLObject.getElementQName());
                marshaller.marshall(childXMLObject, domElement);
            }
        } else {
            this.log.trace("No child elements to marshall for XMLObject {}", (Object)xmlObject.getElementQName());
        }
    }

    protected void marshallNamespaces(XMLObject xmlObject, Element domElement) {
        this.log.trace("Marshalling namespace attributes for XMLObject {}", (Object)xmlObject.getElementQName());
        Set<Namespace> namespaces = xmlObject.getNamespaces();
        for (Namespace namespace : namespaces) {
            if (!namespace.alwaysDeclare() && XMLHelper.lookupNamespaceURI(domElement, namespace.getNamespacePrefix()) != null) {
                this.log.trace("Namespace {} has already been declared on an ancestor of no need to add it here", (Object)namespace, (Object)xmlObject.getElementQName());
                continue;
            }
            this.log.trace("Adding namespace decleration {} to {}", (Object)namespace, (Object)xmlObject.getElementQName());
            String nsURI = DatatypeHelper.safeTrimOrNullString(namespace.getNamespaceURI());
            String nsPrefix = DatatypeHelper.safeTrimOrNullString(namespace.getNamespacePrefix());
            XMLHelper.appendNamespaceDeclaration(domElement, nsURI, nsPrefix);
        }
    }

    protected void marshallSchemaInstanceAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException {
        QName type;
        if (!DatatypeHelper.isEmpty(xmlObject.getSchemaLocation())) {
            this.log.trace("Setting xsi:schemaLocation for XMLObject {} to {}", (Object)xmlObject.getElementQName(), (Object)xmlObject.getSchemaLocation());
            domElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", xmlObject.getSchemaLocation());
        }
        if (!DatatypeHelper.isEmpty(xmlObject.getNoNamespaceSchemaLocation())) {
            this.log.trace("Setting xsi:noNamespaceSchemaLocation for XMLObject {} to {}", (Object)xmlObject.getElementQName(), (Object)xmlObject.getNoNamespaceSchemaLocation());
            domElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:noNamespaceSchemaLocation", xmlObject.getNoNamespaceSchemaLocation());
        }
        if ((type = xmlObject.getSchemaType()) == null) {
            return;
        }
        this.log.trace("Setting xsi:type attribute with for XMLObject {}", (Object)xmlObject.getElementQName());
        String typeLocalName = DatatypeHelper.safeTrimOrNullString(type.getLocalPart());
        String typePrefix = DatatypeHelper.safeTrimOrNullString(type.getPrefix());
        if (typeLocalName == null) {
            throw new MarshallingException("The type QName on XMLObject " + xmlObject.getElementQName() + " may not have a null local name");
        }
        if (type.getNamespaceURI() == null) {
            throw new MarshallingException("The type URI QName on XMLObject " + xmlObject.getElementQName() + " may not have a null namespace URI");
        }
        String attributeValue = typePrefix == null ? typeLocalName : String.valueOf(typePrefix) + ":" + typeLocalName;
        domElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", attributeValue);
        this.log.trace("Adding XSI namespace to list of namespaces used by XMLObject {}", (Object)xmlObject.getElementQName());
        xmlObject.addNamespace(new Namespace("http://www.w3.org/2001/XMLSchema-instance", "xsi"));
    }

    protected abstract void marshallAttributes(XMLObject var1, Element var2) throws MarshallingException;

    protected abstract void marshallElementContent(XMLObject var1, Element var2) throws MarshallingException;

    private void prepareForAdoption(XMLObject domCachingObject) throws MarshallingException {
        if (domCachingObject.getParent() != null) {
            this.log.trace("Rooting all visible namespaces of XMLObject {} before adding it to new parent Element", (Object)domCachingObject.getElementQName());
            try {
                XMLHelper.rootNamespaces(domCachingObject.getDOM());
            }
            catch (XMLParserException e) {
                String errorMsg = "Unable to root namespaces of cached DOM element, " + domCachingObject.getElementQName();
                this.log.error(errorMsg, (Throwable)e);
                throw new MarshallingException(errorMsg, e);
            }
            this.log.trace("Release DOM of XMLObject parent");
            domCachingObject.releaseParentDOM(true);
        }
    }
}

