/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.parse;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.parse.LoggingErrorHandler;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.util.LazyMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicParserPool
implements ParserPool {
    private final Logger log = LoggerFactory.getLogger(BasicParserPool.class);
    private long poolVersion;
    private boolean createBuildersAtPoolLimit;
    private boolean dirtyBuilderConfiguration;
    private DocumentBuilderFactory builderFactory;
    private Stack<SoftReference<DocumentBuilder>> builderPool;
    private int maxPoolSize;
    private Map<String, Object> builderAttributes;
    private boolean coalescing;
    private boolean expandEntityReferences;
    private Map<String, Boolean> builderFeatures;
    private boolean ignoreComments;
    private boolean ignoreElementContentWhitespace;
    private boolean namespaceAware;
    private Schema schema;
    private boolean dtdValidating;
    private boolean xincludeAware;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;

    public BasicParserPool() {
        Configuration.validateNonSunJAXP();
        this.maxPoolSize = 5;
        this.builderPool = new Stack();
        this.builderAttributes = new LazyMap<String, Object>();
        this.coalescing = true;
        this.expandEntityReferences = true;
        this.builderFeatures = new LazyMap<String, Boolean>();
        this.ignoreComments = true;
        this.ignoreElementContentWhitespace = true;
        this.namespaceAware = true;
        this.schema = null;
        this.dtdValidating = false;
        this.xincludeAware = false;
        this.errorHandler = new LoggingErrorHandler(this.log);
        try {
            this.dirtyBuilderConfiguration = true;
            this.initializePool();
        }
        catch (XMLParserException xMLParserException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentBuilder getBuilder() throws XMLParserException {
        DocumentBuilder builder = null;
        try {
            if (this.dirtyBuilderConfiguration) {
                this.initializePool();
            }
            Stack<SoftReference<DocumentBuilder>> stack = this.builderPool;
            synchronized (stack) {
                builder = this.builderPool.pop().get();
            }
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        if (builder == null && (this.builderPool.size() < this.maxPoolSize || this.createBuildersAtPoolLimit)) {
            builder = this.createBuilder();
        }
        if (builder != null) {
            return new DocumentBuilderProxy(builder, this);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnBuilder(DocumentBuilder builder) {
        if (!(builder instanceof DocumentBuilderProxy)) {
            return;
        }
        DocumentBuilderProxy proxiedBuilder = (DocumentBuilderProxy)builder;
        if (proxiedBuilder.getOwningPool() != this || proxiedBuilder.getPoolVersion() != this.poolVersion) {
            return;
        }
        DocumentBuilder unwrappedBuilder = proxiedBuilder.getProxiedBuilder();
        unwrappedBuilder.reset();
        SoftReference<DocumentBuilder> builderReference = new SoftReference<DocumentBuilder>(unwrappedBuilder);
        Stack<SoftReference<DocumentBuilder>> stack = this.builderPool;
        synchronized (stack) {
            if (this.builderPool.size() < this.maxPoolSize) {
                this.builderPool.push(builderReference);
            }
        }
    }

    @Override
    public Document newDocument() throws XMLParserException {
        DocumentBuilder builder = this.getBuilder();
        Document document = builder.newDocument();
        this.returnBuilder(builder);
        return document;
    }

    @Override
    public Document parse(InputStream input) throws XMLParserException {
        DocumentBuilder builder = this.getBuilder();
        try {
            Document document;
            Document document2 = document = builder.parse(input);
            return document2;
        }
        catch (SAXException e) {
            throw new XMLParserException("Invalid XML", e);
        }
        catch (IOException e) {
            throw new XMLParserException("Unable to read XML from input stream", e);
        }
        finally {
            this.returnBuilder(builder);
        }
    }

    @Override
    public Document parse(Reader input) throws XMLParserException {
        DocumentBuilder builder = this.getBuilder();
        try {
            Document document;
            Document document2 = document = builder.parse(new InputSource(input));
            return document2;
        }
        catch (SAXException e) {
            throw new XMLParserException("Invalid XML", e);
        }
        catch (IOException e) {
            throw new XMLParserException("Unable to read XML from input stream", e);
        }
        finally {
            this.returnBuilder(builder);
        }
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int newSize) {
        this.maxPoolSize = newSize;
    }

    public boolean getCreateBuildersAtPoolLimit() {
        return this.createBuildersAtPoolLimit;
    }

    public void setCreateBuildersAtPoolLimit(boolean createBuilders) {
        this.createBuildersAtPoolLimit = createBuilders;
    }

    public Map<String, Object> getBuilderAttributes() {
        return Collections.unmodifiableMap(this.builderAttributes);
    }

    public void setBuilderAttributes(Map<String, Object> newAttributes) {
        this.builderAttributes = newAttributes;
        this.dirtyBuilderConfiguration = true;
    }

    public boolean isCoalescing() {
        return this.coalescing;
    }

    public void setCoalescing(boolean isCoalescing) {
        this.coalescing = isCoalescing;
        this.dirtyBuilderConfiguration = true;
    }

    public boolean isExpandEntityReferences() {
        return this.expandEntityReferences;
    }

    public void setExpandEntityReferences(boolean expand) {
        this.expandEntityReferences = expand;
        this.dirtyBuilderConfiguration = true;
    }

    public Map<String, Boolean> getBuilderFeatures() {
        return Collections.unmodifiableMap(this.builderFeatures);
    }

    public void setBuilderFeatures(Map<String, Boolean> newFeatures) {
        this.builderFeatures = newFeatures;
        this.dirtyBuilderConfiguration = true;
    }

    public boolean getIgnoreComments() {
        return this.ignoreComments;
    }

    public void setIgnoreComments(boolean ignore) {
        this.ignoreComments = ignore;
        this.dirtyBuilderConfiguration = true;
    }

    public boolean isIgnoreElementContentWhitespace() {
        return this.ignoreElementContentWhitespace;
    }

    public void setIgnoreElementContentWhitespace(boolean ignore) {
        this.ignoreElementContentWhitespace = ignore;
        this.dirtyBuilderConfiguration = true;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean isNamespaceAware) {
        this.namespaceAware = isNamespaceAware;
        this.dirtyBuilderConfiguration = true;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(Schema newSchema) {
        this.schema = newSchema;
        if (this.schema != null) {
            this.setNamespaceAware(true);
            this.builderAttributes.remove("http://java.sun.com/xml/jaxp/properties/schemaSource");
            this.builderAttributes.remove("http://java.sun.com/xml/jaxp/properties/schemaLanguage");
        }
        this.dirtyBuilderConfiguration = true;
    }

    public boolean isDTDValidating() {
        return this.dtdValidating;
    }

    public void setDTDValidating(boolean isValidating) {
        this.dtdValidating = isValidating;
        this.dirtyBuilderConfiguration = true;
    }

    public boolean isXincludeAware() {
        return this.xincludeAware;
    }

    public void setXincludeAware(boolean isXIncludeAware) {
        this.xincludeAware = isXIncludeAware;
        this.dirtyBuilderConfiguration = true;
    }

    protected long getPoolVersion() {
        return this.poolVersion;
    }

    protected synchronized void initializePool() throws XMLParserException {
        if (!this.dirtyBuilderConfiguration) {
            return;
        }
        try {
            DocumentBuilderFactory newFactory = DocumentBuilderFactory.newInstance();
            for (Map.Entry<String, Object> entry : this.builderAttributes.entrySet()) {
                newFactory.setAttribute(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.builderFeatures.entrySet()) {
                if (entry.getKey() == null) continue;
                newFactory.setFeature(entry.getKey(), (Boolean)entry.getValue());
            }
            newFactory.setCoalescing(this.coalescing);
            newFactory.setExpandEntityReferences(this.expandEntityReferences);
            newFactory.setIgnoringComments(this.ignoreComments);
            newFactory.setIgnoringElementContentWhitespace(this.ignoreElementContentWhitespace);
            newFactory.setNamespaceAware(this.namespaceAware);
            newFactory.setSchema(this.schema);
            newFactory.setValidating(this.dtdValidating);
            newFactory.setXIncludeAware(this.xincludeAware);
            ++this.poolVersion;
            this.dirtyBuilderConfiguration = false;
            this.builderFactory = newFactory;
            this.builderPool.clear();
        }
        catch (ParserConfigurationException e) {
            throw new XMLParserException("Unable to configure builder factory", e);
        }
    }

    protected DocumentBuilder createBuilder() throws XMLParserException {
        try {
            DocumentBuilder builder = this.builderFactory.newDocumentBuilder();
            if (this.entityResolver != null) {
                builder.setEntityResolver(this.entityResolver);
            }
            if (this.errorHandler != null) {
                builder.setErrorHandler(this.errorHandler);
            }
            return builder;
        }
        catch (ParserConfigurationException e) {
            this.log.error("Unable to create new document builder", (Throwable)e);
            throw new XMLParserException("Unable to create new document builder", e);
        }
    }

    protected class DocumentBuilderProxy
    extends DocumentBuilder {
        private DocumentBuilder builder;
        private ParserPool owningPool;
        private long owningPoolVersion;

        public DocumentBuilderProxy(DocumentBuilder target, BasicParserPool owner) {
            this.owningPoolVersion = owner.getPoolVersion();
            this.owningPool = owner;
            this.builder = target;
        }

        public DOMImplementation getDOMImplementation() {
            return this.builder.getDOMImplementation();
        }

        public Schema getSchema() {
            return this.builder.getSchema();
        }

        public boolean isNamespaceAware() {
            return this.builder.isNamespaceAware();
        }

        public boolean isValidating() {
            return this.builder.isValidating();
        }

        public boolean isXIncludeAware() {
            return this.builder.isXIncludeAware();
        }

        public Document newDocument() {
            return this.builder.newDocument();
        }

        public Document parse(File f) throws SAXException, IOException {
            return this.builder.parse(f);
        }

        public Document parse(InputSource is) throws SAXException, IOException {
            return this.builder.parse(is);
        }

        public Document parse(InputStream is) throws SAXException, IOException {
            return this.builder.parse(is);
        }

        public Document parse(InputStream is, String systemId) throws SAXException, IOException {
            return this.builder.parse(is, systemId);
        }

        public Document parse(String uri) throws SAXException, IOException {
            return this.builder.parse(uri);
        }

        public void reset() {
        }

        public void setEntityResolver(EntityResolver er) {
        }

        public void setErrorHandler(ErrorHandler eh) {
        }

        protected ParserPool getOwningPool() {
            return this.owningPool;
        }

        protected long getPoolVersion() {
            return this.owningPoolVersion;
        }

        protected DocumentBuilder getProxiedBuilder() {
            return this.builder;
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.owningPool.returnBuilder(this);
        }
    }
}

