/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security;

import java.io.ByteArrayInputStream;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.xml.security.Init;
import org.apache.xml.security.algorithms.JCEMapper;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.BasicCredential;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.keyinfo.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.KeyInfoProvider;
import org.opensaml.xml.security.keyinfo.provider.DSAKeyValueProvider;
import org.opensaml.xml.security.keyinfo.provider.InlineX509DataProvider;
import org.opensaml.xml.security.keyinfo.provider.RSAKeyValueProvider;
import org.opensaml.xml.util.Base64;

public final class SecurityTestHelper {
    static {
        if (!Init.isInitialized()) {
            Init.init();
        }
    }

    private SecurityTestHelper() {
    }

    public static X509Certificate buildJavaX509Cert(String base64Cert) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream input = new ByteArrayInputStream(Base64.decode(base64Cert));
        return (X509Certificate)cf.generateCertificate(input);
    }

    public static X509CRL buildJavaX509CRL(String base64CRL) throws CertificateException, CRLException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream input = new ByteArrayInputStream(Base64.decode(base64CRL));
        return (X509CRL)cf.generateCRL(input);
    }

    public static DSAPublicKey buildJavaDSAPublicKey(String base64EncodedKey) throws KeyException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.decode(base64EncodedKey));
        return (DSAPublicKey)SecurityTestHelper.buildKey(keySpec, "DSA");
    }

    public static RSAPublicKey buildJavaRSAPublicKey(String base64EncodedKey) throws KeyException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.decode(base64EncodedKey));
        return (RSAPublicKey)SecurityTestHelper.buildKey(keySpec, "RSA");
    }

    public static RSAPrivateKey buildJavaRSAPrivateKey(String base64EncodedKey) throws KeyException {
        PrivateKey key = SecurityTestHelper.buildJavaPrivateKey(base64EncodedKey);
        if (!(key instanceof RSAPrivateKey)) {
            throw new KeyException("Generated key was not an RSAPrivateKey instance");
        }
        return (RSAPrivateKey)key;
    }

    public static DSAPrivateKey buildJavaDSAPrivateKey(String base64EncodedKey) throws KeyException {
        PrivateKey key = SecurityTestHelper.buildJavaPrivateKey(base64EncodedKey);
        if (!(key instanceof DSAPrivateKey)) {
            throw new KeyException("Generated key was not a DSAPrivateKey instance");
        }
        return (DSAPrivateKey)key;
    }

    public static PrivateKey buildJavaPrivateKey(String base64EncodedKey) throws KeyException {
        return SecurityHelper.decodePrivateKey(Base64.decode(base64EncodedKey), null);
    }

    public static PublicKey buildKey(KeySpec keySpec, String keyAlgorithm) throws KeyException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(keyAlgorithm);
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyException(String.valueOf(keyAlgorithm) + "algorithm is not supported by the JCE", e);
        }
        catch (InvalidKeySpecException e) {
            throw new KeyException("Invalid key information", e);
        }
    }

    public static SecretKey generateKeyFromURI(String algoURI) throws NoSuchAlgorithmException, NoSuchProviderException {
        String jceAlgorithmName = JCEMapper.getJCEKeyAlgorithmFromURI((String)algoURI);
        int keyLength = JCEMapper.getKeyLengthFromURI((String)algoURI);
        return SecurityTestHelper.generateKey(jceAlgorithmName, keyLength, null);
    }

    public static KeyPair generateKeyPairFromURI(String algoURI, int keyLength) throws NoSuchAlgorithmException, NoSuchProviderException {
        String jceAlgorithmName = JCEMapper.getJCEKeyAlgorithmFromURI((String)algoURI);
        return SecurityTestHelper.generateKeyPair(jceAlgorithmName, keyLength, null);
    }

    public static SecretKey generateKey(String algo, int keyLength, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        SecretKey key = null;
        KeyGenerator keyGenerator = null;
        keyGenerator = provider != null ? KeyGenerator.getInstance(algo, provider) : KeyGenerator.getInstance(algo);
        keyGenerator.init(keyLength);
        key = keyGenerator.generateKey();
        return key;
    }

    public static KeyPair generateKeyPair(String algo, int keyLength, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator keyGenerator = null;
        keyGenerator = provider != null ? KeyPairGenerator.getInstance(algo, provider) : KeyPairGenerator.getInstance(algo);
        keyGenerator.initialize(keyLength);
        return keyGenerator.generateKeyPair();
    }

    public static Credential generateKeyAndCredential(String algorithmURI) throws NoSuchAlgorithmException, NoSuchProviderException {
        SecretKey key = SecurityTestHelper.generateKeyFromURI(algorithmURI);
        BasicCredential credential = new BasicCredential();
        credential.setSecretKey(key);
        return credential;
    }

    public static Credential generateKeyPairAndCredential(String algorithmURI, int keyLength, boolean includePrivate) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPair keyPair = SecurityTestHelper.generateKeyPairFromURI(algorithmURI, keyLength);
        BasicCredential credential = new BasicCredential();
        credential.setPublicKey(keyPair.getPublic());
        if (includePrivate) {
            credential.setPrivateKey(keyPair.getPrivate());
        }
        return credential;
    }

    public static KeyInfoCredentialResolver buildBasicInlineKeyInfoResolver() {
        ArrayList<KeyInfoProvider> providers = new ArrayList<KeyInfoProvider>();
        providers.add(new RSAKeyValueProvider());
        providers.add(new DSAKeyValueProvider());
        providers.add(new InlineX509DataProvider());
        return new BasicProviderKeyInfoCredentialResolver(providers);
    }
}

