/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.util;

import java.util.AbstractList;
import java.util.List;
import javax.xml.namespace.QName;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.IndexedXMLObjectChildrenList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ListView<ElementType extends XMLObject>
extends AbstractList<ElementType> {
    private IndexedXMLObjectChildrenList<ElementType> backingList;
    private QName index;
    private List<ElementType> indexList;

    public ListView(IndexedXMLObjectChildrenList<ElementType> newBackingList, QName newIndex) {
        this.backingList = newBackingList;
        this.index = newIndex;
        this.indexList = this.backingList.get(this.index);
    }

    @Override
    public boolean contains(ElementType element) {
        return this.indexList.contains(element);
    }

    @Override
    public ElementType get(int newIndex) {
        return (ElementType)((XMLObject)this.indexList.get(newIndex));
    }

    @Override
    public int size() {
        return this.indexList.size();
    }

    @Override
    public ElementType set(int newIndex, ElementType element) {
        if (newIndex < 0 && newIndex > this.indexList.size()) {
            throw new IndexOutOfBoundsException();
        }
        XMLObject replacedElement = (XMLObject)this.indexList.get(newIndex);
        int elementIndex = this.backingList.indexOf(replacedElement);
        this.backingList.set(elementIndex, element);
        return (ElementType)replacedElement;
    }

    @Override
    public void add(int newIndex, ElementType element) {
        this.indexCheck(element);
        this.backingList.add(element);
    }

    @Override
    public ElementType remove(int newIndex) {
        return this.backingList.remove(newIndex);
    }

    protected void indexCheck(ElementType element) throws IllegalArgumentException {
        if (this.index.equals(element.getSchemaType()) || this.index.equals(element.getElementQName())) {
            return;
        }
        throw new IllegalArgumentException("Element " + element.getElementQName() + " is not of type " + this.index);
    }
}

