/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import org.apache.log4j.Level;
import org.apache.log4j.Log4jLoggerFactory;
import org.apache.log4j.Priority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class Category {
    private String name;
    protected Logger slf4jLogger;
    private LocationAwareLogger locationAwareLogger;
    private static Marker FATAL_MARKER = MarkerFactory.getMarker((String)"FATAL");

    Category(String name) {
        this.name = name;
        this.slf4jLogger = LoggerFactory.getLogger((String)name);
        if (this.slf4jLogger instanceof LocationAwareLogger) {
            this.locationAwareLogger = (LocationAwareLogger)this.slf4jLogger;
        }
    }

    public static Category getInstance(Class clazz) {
        return Log4jLoggerFactory.getLogger(clazz.getName());
    }

    public static Category getInstance(String name) {
        return Log4jLoggerFactory.getLogger(name);
    }

    public String getName() {
        return this.name;
    }

    public Level getEffectiveLevel() {
        if (this.slf4jLogger.isTraceEnabled()) {
            return Level.TRACE;
        }
        if (this.slf4jLogger.isDebugEnabled()) {
            return Level.DEBUG;
        }
        if (this.slf4jLogger.isInfoEnabled()) {
            return Level.INFO;
        }
        if (this.slf4jLogger.isWarnEnabled()) {
            return Level.WARN;
        }
        return Level.ERROR;
    }

    public final Level getLevel() {
        return null;
    }

    public final Level getPriority() {
        return null;
    }

    public boolean isDebugEnabled() {
        return this.slf4jLogger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.slf4jLogger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.slf4jLogger.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.slf4jLogger.isErrorEnabled();
    }

    public boolean isEnabledFor(Priority p) {
        switch (p.level) {
            case 5000: {
                return this.slf4jLogger.isTraceEnabled();
            }
            case 10000: {
                return this.slf4jLogger.isDebugEnabled();
            }
            case 20000: {
                return this.slf4jLogger.isInfoEnabled();
            }
            case 30000: {
                return this.slf4jLogger.isWarnEnabled();
            }
            case 40000: {
                return this.slf4jLogger.isErrorEnabled();
            }
            case 50000: {
                return this.slf4jLogger.isErrorEnabled();
            }
        }
        return false;
    }

    public void debug(Object message) {
        this.slf4jLogger.debug(this.convertToString(message));
    }

    public void debug(Object message, Throwable t) {
        this.slf4jLogger.debug(this.convertToString(message), t);
    }

    public void info(Object message) {
        this.slf4jLogger.info(this.convertToString(message));
    }

    public void info(Object message, Throwable t) {
        this.slf4jLogger.info(this.convertToString(message), t);
    }

    public void warn(Object message) {
        this.slf4jLogger.warn(this.convertToString(message));
    }

    public void warn(Object message, Throwable t) {
        this.slf4jLogger.warn(this.convertToString(message), t);
    }

    public void error(Object message) {
        this.slf4jLogger.error(this.convertToString(message));
    }

    public void error(Object message, Throwable t) {
        this.slf4jLogger.error(this.convertToString(message), t);
    }

    public void fatal(Object message) {
        this.slf4jLogger.error(FATAL_MARKER, this.convertToString(message));
    }

    public void fatal(Object message, Throwable t) {
        this.slf4jLogger.error(FATAL_MARKER, this.convertToString(message), t);
    }

    public void log(String FQCN, Priority p, Object msg, Throwable t) {
        int levelInt = this.priorityToLevelInt(p);
        if (this.locationAwareLogger != null) {
            if (msg != null) {
                this.locationAwareLogger.log(null, FQCN, levelInt, msg.toString(), t);
            } else {
                this.locationAwareLogger.log(null, FQCN, levelInt, null, t);
            }
        } else {
            throw new UnsupportedOperationException("The logger [" + this.slf4jLogger + "] does not seem to be location aware.");
        }
    }

    private int priorityToLevelInt(Priority p) {
        switch (p.level) {
            case 5000: {
                return 0;
            }
            case 10000: {
                return 10;
            }
            case 20000: {
                return 20;
            }
            case 30000: {
                return 30;
            }
            case 40000: {
                return 40;
            }
            case 50000: {
                return 40;
            }
        }
        throw new IllegalStateException("Unknown Priority " + p);
    }

    protected final String convertToString(Object message) {
        if (message == null) {
            return (String)message;
        }
        return message.toString();
    }
}

